package edu.jhu.ece.iacl.algorithms.dti;

import edu.jhu.ece.iacl.algorithms.dti.EstimateTensorLLMSE;
import Jama.Matrix;
import java.util.ArrayList;

public class EstimateTensorWildBoot {
	//private static boolean detailedDebugging = false;

	public static float[][][][] estimate(int iterWB, float [][][][]inDWdata, 
			float []inbvalues, float [][]ingrads, byte [][][]inmask, boolean usePartialEstimates) {
		System.out.println("Wild Boot tensor estimation started");
		int trueLenOfGrads = 0;
		for(int i = 0; i < inDWdata[0][0][0].length; i++){
			float []q = ingrads[i];
			if(q[0]*q[0] + q[1]*q[1] + q[2]*q[2] < 100){
				trueLenOfGrads++;
			}
		}
		
		float [][][][]DWdata = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][trueLenOfGrads];
		float [][][][]meanTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][6];
		float [][][]varTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length];
		float [][][]confiTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length];
		//float [][][][]modeTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][6];
		float []bvalues = new float[trueLenOfGrads];
		float [][]grads = new float[trueLenOfGrads][3];

		float [][][]FA = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length];
		float [][][][]VEC1 = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][3];
		
		//1	Computer FA and VEC1
		int indexOfDWdata = 0;
		
		// Get gradient table and bvalues
		for(int i = 0;i < inDWdata[0][0][0].length; i++){
			float []q = ingrads[i];
			if(q[0]*q[0] + q[1]*q[1] + q[2]*q[2] < 100){
				for(int ii = 0; ii < inDWdata.length; ii++){
					for(int jj = 0; jj < inDWdata[0].length; jj++){
						for(int kk = 0; kk < inDWdata[0][0].length; kk++){
							DWdata[ii][jj][kk][indexOfDWdata] = inDWdata[ii][jj][kk][i];
						}
					}
				}
				bvalues[indexOfDWdata] = inbvalues[i];
				grads[indexOfDWdata] = ingrads[i];
				indexOfDWdata++;
			}
			//System.out.println(indexOfDWdata);
		}
	
		//float [][][][]DWdata = inDWdata;

		//System.out.println(DWdata.length);
		//System.out.println(DWdata[0].length);
		//System.out.println(DWdata[0][0].length);
		//System.out.println(DWdata[0][0][0].length);
		//System.out.println(bvalues.length);

		
		
		byte [][][]mask = inmask;
		System.out.println("Staring initial tensor estimation");
		float tensors[][][][] = EstimateTensorLLMSE.estimate(DWdata, bvalues, grads, mask, usePartialEstimates);
		System.out.println("Initial tensor estimation complete");

		for(int i = 0; i < DWdata.length;i++){
			for(int j = 0; j < DWdata[0].length;j++){
				for(int k = 0; k < DWdata[0][0].length;k++){
					if(mask!=null){
						if(mask[i][j][k] == 0){
							System.out.println(i + "," + j + "," + k +": NaN");
							tensors[i][j][k][0] = Float.NaN;
							tensors[i][j][k][1] = Float.NaN;
							tensors[i][j][k][2] = Float.NaN;
							tensors[i][j][k][3] = Float.NaN;
							tensors[i][j][k][4] = Float.NaN;
							tensors[i][j][k][5] = Float.NaN;
							continue;
						}
					}
					double []Dprojection = EstimateTensorWildBoot.projectTensor(tensors[i][j][k], grads, bvalues);
					System.out.println("Projection: " + i + "," + j + "," + k + " complete");
					double []residuals = new double[Dprojection.length];
					System.out.println("Residuals[0]: " + residuals[0]);
					for(int l = 0; l < Dprojection.length; l++){
						residuals[l] = DWdata[i][j][k][0]*Dprojection[l]-DWdata[i][j][k][l];
						//System.out.println("Residuals["+i+"]: " + residuals[l]);
						//System.out.println("Residuals["+i+"](%): " + residuals[l]/DWdata[i][j][k][l]);
					}
					
					float [][][][][]tempTensorijk = new float[iterWB][1][1][1][6];
					/*for(int ii = 0; ii < iterWB; ii++){
						tempTensorijk[ii][0][0][0][0] = 0;
						tempTensorijk[ii][0][0][0][1] = 0;
						tempTensorijk[ii][0][0][0][2] = 0;
						tempTensorijk[ii][0][0][0][3] = 0;
						tempTensorijk[ii][0][0][0][4] = 0;
						tempTensorijk[ii][0][0][0][5] = 0;
					}*/
					
					float [][][][]tempDW = new float[1][1][1][DWdata[0][0][0].length];
					for(int iter = 0;iter < iterWB; iter++){
						for(int l = 0; l < Dprojection.length; l++){
							int index = (int) Math.floor(Math.random()*Dprojection.length);
							if(index >= Dprojection.length){
								System.out.println("index >= Dprojection.length");
							}
							boolean sign = Math.random()>.5;
							if(sign) {
//								/DWdata[i][j][k][i] = Math.max(1,(float)Dprojection[i]+(float)residuals[index]);
								//DWdata[i][j][k][l] = (float)Dprojection[l]+(float)residuals[index];
								tempDW[0][0][0][l] = Math.max(1, (float)Dprojection[l]+(float)residuals[index]);
							} 
							else {
								//DWdata[i][j][k][i] = Math.max(1,(float)Dprojection[i]-(float)residuals[index]);
								//DWdata[i][j][k][l] = (float)Dprojection[l]-(float)residuals[index];
								tempDW[0][0][0][l] = Math.max(1, (float)Dprojection[l]-(float)residuals[index]);
							}
							//System.out.println("DWdata:" + tempDW[0][0][0][l]);
						}
						//tempTensorijk[iter] = EstimateTensorWildBoot.estimatevoxeltensor(tempDW[0][0][0], bvalues, grads);
						tempTensorijk[iter] = EstimateTensorLLMSE.estimate(tempDW, bvalues, grads, mask, usePartialEstimates);
						//System.out.println("tempTensorijk:" + tempTensorijk[iter][0][0][0][0]);
					}
					tensors[i][j][k] = EstimateTensorWildBoot.meanTensor(tempTensorijk);
					System.out.println("tensors["+i+"]["+j+"]["+k+"][0]: " + tensors[i][j][k][0]);
					System.out.println("tensors["+i+"]["+j+"]["+k+"][3]: " + tensors[i][j][k][3]);
					System.out.println("tensors["+i+"]["+j+"]["+k+"][5]: " + tensors[i][j][k][5]);
					//meanTensor, varTensor
					//modeTensor
				}
			}
			//tensors = EstimateTensorLLMSE.estimate(DWdata, bvalues, grads, mask, usePartialEstimates);
			
		}
		//tensors = EstimateTensorLLMSE.estimate(DWdata, bvalues, grads, mask, usePartialEstimates);
		return tensors;
	}
	
	static public float[] estimatevoxeltensor(float []DW, float []bvalues, float [][]grads){
		float []tensor = new float[6];
		//float []est = new float[7];
		Matrix logDW = new Matrix(DW.length-1,1);
		
		for(int i = 0; i < DW.length-1; i++){
			System.out.println("matrix DW: " + DW[i] + ", " + "logDW: " + Math.log(DW[i]));
			logDW.set(i, 0, Math.log(DW[i]));
		}
		System.out.println("matrix lofloat []q = grads[i];gDW init " + logDW.get(0, 0));
		Matrix G = new Matrix(DW.length-1, 7);
		for(int i=0;i<grads.length-1;i++) {
			
			float []q = grads[i];
			
			double Gx = q[0];
			double Gy = q[1];
			double Gz = q[2];
			double norm = Math.sqrt(Gx * Gx + Gy * Gy + Gz * Gz);
			if(norm != 0){
				Gx = Gx/norm;
				Gy = Gy/norm;
				Gz = Gz/norm;
			}
			G.set(i, 0, -Gx*Gx*bvalues[i]);
			G.set(i, 1, -Gx*Gy*bvalues[i]);
			G.set(i, 2, -Gx*Gz*bvalues[i]);
			G.set(i, 3, -Gy*Gy*bvalues[i]);
			G.set(i, 4, -Gy*Gz*bvalues[i]);
			G.set(i, 5, -Gz*Gz*bvalues[i]);	
			G.set(i, 6, 1);	
		}
		//System.out.println("matrix G init: " + G.get(0, 0));
		Matrix GT = G.transpose();
		//System.out.println("matrix GT init: " + GT.get(0, 0));
		Matrix GTG = GT.times(G);
		//System.out.println("matrix GTG init: " + GTG.get(0, 0));
		Matrix GTG_inv = GTG.inverse();
		//System.out.println("matrix GTG_inv init: " + GTG_inv.get(0, 0));
		Matrix GTy = GT.times(logDW);
		Matrix mtensor = GTG_inv.times(GTy);
		System.out.println("matrix mtensor init: " + mtensor.get(0, 0));
		for(int i = 0; i < 6 ; i++){
			tensor[i] = (float)mtensor.get(i, 0);
			System.out.println("tensor[" + i + "]: " + tensor[i]);
		}
		return tensor;
	}
	
	static public double[] projectTensor(float[] outTensors, float [][]grads, float []bvalues) {
		
		double []proj = new double[grads.length];
		double Dxx = outTensors[0];
		double Dxy = outTensors[1];
		double Dxz = outTensors[2];
		double Dyy = outTensors[3];
		double Dyz = outTensors[4];
		double Dzz = outTensors[5];
		
		for(int i=0;i<grads.length;i++) {
			
			float []q = grads[i];
			
			double Gx = q[0];
			double Gy = q[1];
			double Gz = q[2];
			double norm = Math.sqrt(Gx * Gx + Gy * Gy + Gz * Gz);
			if(norm != 0){
				Gx = Gx/norm;
				Gy = Gy/norm;
				Gz = Gz/norm;
			}
		
			proj[i] = Math.exp(-bvalues[i] *
					(Gx*Gx*Dxx + 
							2*Gx*Gy*Dxy+
							2*Gx*Gz*Dxz+
							Gy*Gy*Dyy+
							2*Gy*Gz*Dyz+
							Gz*Gz*Dzz));
		}
		
		return proj;
	}
	public static float[][][][] estimateLog(int iterWB, float [][][][]inDWdata, 
			float []inbvalues, float [][]ingrads, byte [][][]inmask, boolean usePartialEstimates) {
		System.out.println("Wild Boot tensor estimation started");
		
		//preprocess to get real DWI
		int trueLenOfGrads = 0;
		for(int i = 0; i < ingrads.length; i++){
			float []q = ingrads[i];
			if(q[0]*q[0] + q[1]*q[1] + q[2]*q[2] < 100){
				trueLenOfGrads++;
			}
		}
		
		float [][][][]DWdata = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][trueLenOfGrads];
		float [][][][]meanTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][6];
		float [][][]varTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length];
		float [][][][]modeTensor = new float[inDWdata.length][inDWdata[0].length][inDWdata[0][0].length][6];
		float []bvalues = new float[trueLenOfGrads];
		float [][]grads = new float[trueLenOfGrads][3];

		int indexOfDWdata = 0;
		for(int i = 0;i < ingrads.length; i++){
			float []q = ingrads[i];
			if(q[0]*q[0] + q[1]*q[1] + q[2]*q[2] < 100){
				for(int ii = 0; ii < inDWdata.length; ii++){
					for(int jj = 0; jj < inDWdata[0].length; jj++){
						for(int kk = 0; kk < inDWdata[0][0].length; kk++){
							DWdata[ii][jj][kk][indexOfDWdata] = inDWdata[ii][jj][kk][i];
						}
					}
				}
				bvalues[indexOfDWdata] = inbvalues[i];
				grads[indexOfDWdata] = ingrads[i];
				indexOfDWdata++;
			}
			//System.out.println(indexOfDWdata);
		}
		//System.out.println("trueLenOfGrads: " + trueLenOfGrads);
		//System.out.println("DWdataX: " + DWdata.length);
		//System.out.println("DWdataY: " + DWdata[0].length);
		//System.out.println("DWdataZ: " + DWdata[0][0].length);
		//System.out.println("DWdata: " + DWdata[0][0][0].length);
		//System.out.println("bvalues: " + bvalues.length);
		//System.out.println("grads: " + grads.length);
		//
		byte [][][]mask = inmask;
		//HCCME
		float []diagOfHCCME = EstimateTensorWildBoot.diagOfHCCME(grads, bvalues);
		for(int i=0;i<diagOfHCCME.length;i++){
			System.out.println("diagOfHCCME: "+diagOfHCCME[i]);
		}
		//initial estimation
		float tensors[][][][] = EstimateTensorLLMSE.estimate(DWdata, bvalues, grads, mask, usePartialEstimates);
		
		System.out.println("Initial tensor estimation complete");
		//System.out.println("tesnorX: " + tensors.length);
		//System.out.println("tensorY: " + tensors[0].length);
		//System.out.println("tensorZ: " + tensors[0][0].length);
		//System.out.println("tensor: " + tensors[0][0][0].length);
		//output
		//float []ref = DWdata[0][0][0];
		for(int i = 0; i < DWdata.length;i++){
			for(int j = 0; j < DWdata[0].length;j++){
				for(int k = 0; k < DWdata[0][0].length;k++){
					if(mask!=null){
						if(mask[i][j][k] == 0){
							tensors[i][j][k][0] = Float.NaN;
							tensors[i][j][k][1] = Float.NaN;
							tensors[i][j][k][2] = Float.NaN;
							tensors[i][j][k][3] = Float.NaN;
							tensors[i][j][k][4] = Float.NaN;
							tensors[i][j][k][5] = Float.NaN;
							continue;
						}
					}
					double []Dprojection = 
						EstimateTensorWildBoot.projectTensorLog(DWdata[i][j][k][0], tensors[i][j][k], grads, bvalues);
					//System.out.println("Dprojection: "+Dprojection.length);
					double []residuals = new double[Dprojection.length];
					for(int l = 0; l < Dprojection.length; l++){
						residuals[l] = Dprojection[l]-Math.log(DWdata[i][j][k][l]);
						//System.out.println("residuals["+l+"]: "+residuals[l]+"  "+residuals[l]/(Math.log(DWdata[i][j][k][l])));
					}
					float [][][][][]tempTensorijk = new float[iterWB][1][1][1][6];
					/*for(int ii = 0; ii < iterWB; ii++){
						tempTensorijk[ii][0][0][0][0] = 0;
						tempTensorijk[ii][0][0][0][1] = 0;
						tempTensorijk[ii][0][0][0][2] = 0;
						tempTensorijk[ii][0][0][0][3] = 0;
						tempTensorijk[ii][0][0][0][4] = 0;
						tempTensorijk[ii][0][0][0][5] = 0;
					}*/
					
					float [][][][]tempDW = new float[1][1][1][DWdata[0][0][0].length];
					//System.out.println("iteration: "+ iterWB);
					for(int iter = 0;iter < iterWB; iter++){
						
						for(int l = 0; l < Dprojection.length; l++){
							//int index = (int) Math.floor(Math.random()*Dprojection.length);
							//if(index >= Dprojection.length){
								//System.out.println("index >= Dprojection.length");
							//}
							boolean sign = Math.random()>.5;
							if(sign) {
								//System.out.println("+Dprojection: "+l+" "+Dprojection[l]);
								//System.out.println("diagOfHCCME: "+diagOfHCCME[l]);
								//System.out.println("residuals: " + residuals[l]);
								//System.out.println((float)Dprojection[l]+(1/(1-diagOfHCCME[l])*(float)residuals[l]));
								if(l!=0){
									tempDW[0][0][0][l] = 
										(float)Math.exp(((float)Dprojection[l]+(1/(1-diagOfHCCME[l])*(float)residuals[l])));
									//System.out.println("tempDW:" + tempDW[0][0][0][l]);
								}
								else{
									tempDW[0][0][0][l] = DWdata[i][j][k][l];
								}
								
							} 
							else {
								//System.out.println("-Dprojection: "+l+" "+Dprojection[l]);
								//System.out.println("diagOfHCCME: "+diagOfHCCME[l]);
								//System.out.println("residuals: " + residuals[l]);
								//System.out.println((float)Dprojection[l]-(1/(1-diagOfHCCME[l])*(float)residuals[l]));
								if(l!=0){
									tempDW[0][0][0][l] = 
										(float)Math.exp(((float)Dprojection[l]-(1/(1-diagOfHCCME[l])*(float)residuals[l])));
									//System.out.println("tempDW:" + tempDW[0][0][0][l]);
								}
								else{
									tempDW[0][0][0][l] = DWdata[i][j][k][l];
								}
							}
							/*if(tempDW[0][0][0][l] == Float.NaN){
								System.out.println("l:" + l);
								System.out.println("residuals["+l+"]: "+residuals[l]+residuals[l]/(Math.log(DWdata[i][j][k][l])));
								System.out.println("Dprojection: " + Dprojection[l]);
								System.out.println("diagOfHCCME: "+diagOfHCCME[l]);
							}*/
							
						}
						//tempTensorijk[iter] = EstimateTensorWildBoot.estimatevoxeltensor(tempDW[0][0][0], bvalues, grads);
						tempTensorijk[iter] = EstimateTensorLLMSE.estimate(tempDW, bvalues, grads, mask, usePartialEstimates);
						//System.out.println("tempTensorijk:" + tempTensorijk[iter][0][0][0][0]);
					}
					tensors[i][j][k] = EstimateTensorWildBoot.meanTensor(tempTensorijk);
					meanTensor[i][j][k] = tensors[i][j][k];
					varTensor[i][j][k] = EstimateTensorWildBoot.varTensor(tempTensorijk);
					//System.out.println("tensors["+i+"]["+j+"]["+k+"][0]: " + tensors[i][j][k][0]);
					//System.out.println("tensors["+i+"]["+j+"]["+k+"][3]: " + tensors[i][j][k][3]);
					//System.out.println("tensors["+i+"]["+j+"]["+k+"][5]: " + tensors[i][j][k][5]);
				}
			}
			//tensors = EstimateTensorLLMSE.estimate(DWdata, bvalues, grads, mask, usePartialEstimates);
		}
		System.out.println("tensors estimation complete");
		//tensors = EstimateTensorLLMSE.estimate(DWdata, bvalues, grads, mask, usePartialEstimates);
		return tensors;
	}
	static public double[] projectTensorLog(float S0, float[] outTensors, float [][]grads, float []bvalues) {
		//
		//System.out.println("Projecting Tensor (Log)");
		double []proj = new double[grads.length];
		double Dxx = outTensors[0];
		double Dxy = outTensors[1];
		double Dxz = outTensors[2];
		double Dyy = outTensors[3];
		double Dyz = outTensors[4];
		double Dzz = outTensors[5];
		        
		for(int i=0;i<grads.length;i++) {
			
			float []q = grads[i];
			
			double Gx = q[0];
			double Gy = q[1];
			double Gz = q[2];

			double norm = Math.sqrt(Gx * Gx + Gy * Gy + Gz * Gz);
			if(norm > 100){
				continue;
			}
			if(norm != 0){
				Gx = Gx/norm;
				Gy = Gy/norm;
				Gz = Gz/norm;
			}
		
			proj[i] = -bvalues[i] *
					(Gx*Gx*Dxx + 
							2*Gx*Gy*Dxy+
							2*Gx*Gz*Dxz+
							Gy*Gy*Dyy+
							2*Gy*Gz*Dyz+
							Gz*Gz*Dzz) + Math.log(S0);
		}
		
		return proj;
	}
	static public float[] diagOfHCCME(float [][]grads, float []bvalues) {
		System.out.println("Calculating HCCME");
		float []diag = new float[grads.length];
		//Matrix HCCME = new Matrix(grads.length, grads.length, 0);
		Matrix G = new Matrix(grads.length, 7, 0);
		for(int i = 0; i < grads.length; i++){
			float []q = grads[i];
			
			double Gx = q[0];
			double Gy = q[1];
			double Gz = q[2];
			double norm = Math.sqrt(Gx * Gx + Gy * Gy + Gz * Gz);
			if(norm != 0){
				Gx = Gx/norm;
				Gy = Gy/norm;
				Gz = Gz/norm;
			}
			G.set(i,0,-Gx*Gx*bvalues[i]);
			G.set(i,1,-Gx*Gy*bvalues[i]);
			G.set(i,2,-Gx*Gz*bvalues[i]);
			G.set(i,3,-Gy*Gy*bvalues[i]);
			G.set(i,4,-Gy*Gz*bvalues[i]);
			G.set(i,5,-Gz*Gz*bvalues[i]);
			G.set(i,6,1);
		}
		//System.out.println("Calculating GT");
		Matrix GT = G.transpose();
		//System.out.println("Calculating GTG");
		Matrix GTG = GT.times(G);
		//System.out.println("Calculating GTG_inv");
		Matrix GTG_inv = GTG.inverse();
		//System.out.println("Calculating HCCME");
		Matrix HCCME = G.times(GTG_inv);
		//System.out.println("Calculating HCCME");
		HCCME = HCCME.times(GT);
		
		for(int i = 0; i < grads.length; i++){
			diag[i] = (float)HCCME.get(i, i);
		}
		return diag;
	}
	static public float[] meanTensor(float [][][][][] Tensorijk){
	//System.out.println("Calcaulating mean tensor");
	float []tensor = new float[6];
	float sum0 = 0;
	float sum1 = 0;
	float sum2 = 0;
	float sum3 = 0;
	float sum4 = 0;
	float sum5 = 0;
	for(int i = 0; i < Tensorijk.length; i++){
		sum0 = sum0 + Tensorijk[i][0][0][0][0];
		sum1 = sum1 + Tensorijk[i][0][0][0][1];
		sum2 = sum2 + Tensorijk[i][0][0][0][2];
		sum3 = sum3 + Tensorijk[i][0][0][0][3];
		sum4 = sum4 + Tensorijk[i][0][0][0][4];
		sum5 = sum5 + Tensorijk[i][0][0][0][5];
	}
	tensor[0] = sum0/Tensorijk.length;
	tensor[1] = sum1/Tensorijk.length;
	tensor[2] = sum2/Tensorijk.length;
	tensor[3] = sum3/Tensorijk.length;
	tensor[4] = sum4/Tensorijk.length;
	tensor[5] = sum5/Tensorijk.length;
	
	return tensor;
	}
	static public float varTensor(float [][][][][] Tensorijk){
		//System.out.println("Calcaulating mean tensor");
		float []mean = new float[6];
		float sum0 = 0;
		float sum1 = 0;
		float sum2 = 0;
		float sum3 = 0;
		float sum4 = 0;
		float sum5 = 0;
		for(int i = 0; i < Tensorijk.length; i++){
			sum0 = sum0 + Tensorijk[i][0][0][0][0];
			sum1 = sum1 + Tensorijk[i][0][0][0][1];
			sum2 = sum2 + Tensorijk[i][0][0][0][2];
			sum3 = sum3 + Tensorijk[i][0][0][0][3];
			sum4 = sum4 + Tensorijk[i][0][0][0][4];
			sum5 = sum5 + Tensorijk[i][0][0][0][5];
		}
		mean[0] = sum0/Tensorijk.length;
		mean[1] = sum1/Tensorijk.length;
		mean[2] = sum2/Tensorijk.length;
		mean[3] = sum3/Tensorijk.length;
		mean[4] = sum4/Tensorijk.length;
		mean[5] = sum5/Tensorijk.length;
	
		float sum = 0;

		for(int i = 0; i < Tensorijk.length; i++){
			sum = sum + (Tensorijk[i][0][0][0][0]-mean[0])*(Tensorijk[i][0][0][0][0]-mean[0]);
			sum = sum + (Tensorijk[i][0][0][0][1]-mean[0])*(Tensorijk[i][0][0][0][1]-mean[1]);
			sum = sum + (Tensorijk[i][0][0][0][2]-mean[0])*(Tensorijk[i][0][0][0][2]-mean[2]);
			sum = sum + (Tensorijk[i][0][0][0][3]-mean[0])*(Tensorijk[i][0][0][0][3]-mean[3]);
			sum = sum + (Tensorijk[i][0][0][0][4]-mean[0])*(Tensorijk[i][0][0][0][4]-mean[4]);
			sum = sum + (Tensorijk[i][0][0][0][5]-mean[0])*(Tensorijk[i][0][0][0][5]-mean[5]);
		}
		float var = (float)Math.sqrt(sum/Tensorijk.length);
		return var;
	}
	static public float[] modeTensor(float [][][][][] Tensorijk){
		//System.out.println("Calcaulating mean tensor");
		float []tensor = new float[6];
		ArrayList<Integer> counter = new ArrayList<Integer>(Tensorijk.length);
		ArrayList<Integer> values = new ArrayList<Integer>();
		float [][]value = new float[Tensorijk.length][6];
		for(int i = 0; i < Tensorijk.length; i++){
			
		}
		
		return tensor;
		}
}