package edu.jhu.ece.iacl.algorithms.hardi;

import imaging.DW_Scheme;
//import imaging.Scheme;

import java.util.Vector;

import Jama.Matrix;

public class CFARIBasisSet {

	DW_Scheme acquisition;
	Matrix compressedSensingMatrix;
	Vector<CFARIBasisFunction> basisSet;
	
	public void setDWScheme(DW_Scheme ischeme) {
		acquisition = ischeme;
	}
	
	public DW_Scheme getDWScheme() {
		return acquisition;
	}

	public void setSensingMatrix(Matrix sensingMatrix) { 
		compressedSensingMatrix = (Matrix)sensingMatrix.clone();
	} 
	
	public void setBasisSet(Vector<CFARIBasisFunction> set) {
		basisSet = set;
	}

	public int getNumberOfBasisFunctions() {
		return basisSet.size();
	}

	public Matrix getSensingMatrix() {
		return (Matrix)(compressedSensingMatrix.clone());
	}
	
	public Vector<CFARIBasisFunction> getBasisSet() {
		return (Vector<CFARIBasisFunction>)(basisSet.clone());
	}
	
}
