package edu.jhu.ece.iacl.algorithms.vabra;

import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class VabraRBF{

	private double maxValuesChange; //max change between adjacent values
	private int scale;//scale of the RBF
	public float[][][] values;//values of the RBF
	private int[] offset;//offset to the center of the RBF, {X,Y,Z}
	private int[] maxDim;//the dimension {X,Y,Z} limit for the radius of the RBF corresponding to the image size

	
	public VabraRBF(int maxXDim,int maxYDim,int maxZDim) {
		offset = new int[3];
		scale = 5;
		maxDim = new int[3];
		maxDim[0]= maxXDim;
		maxDim[1]= maxYDim;
		maxDim[2]= maxZDim;
		setScale(5, 5, 5);
	}
	
	public void setScale(float dx, float dy, float dz) {
		setScale((int) Math.ceil(1.7 * Math.max(dx, Math.max(dy, dz))));
	}
		
	public void setScale(int scale) {
		int mult = 1;
		this.scale = scale;
		//scale = (int) Math.ceil(Math.min(dx, Math.min(dy, dz)));
		int i, j, k;
		float temp;
		for(int c = 0; c < 3; c ++)offset[c] = Math.min(maxDim[c],(int)Math.floor(mult * scale));
		
		values = (new ImageDataFloat(2 * offset[0] + 1, 2 * offset[1] + 1, 2 * offset[2] + 1)).toArray3d();
		
		System.out.println(getClass().getCanonicalName()+"\t"+"SCALE X");
		for (i = -offset[0]; i <= offset[0]; i++)
			for (j = -offset[1]; j <= offset[1]; j++)
				for (k = -offset[2]; k <= offset[2]; k++) {
					values[i + offset[0]][j + offset[1]][k + offset[2]] = 0;
				}

		System.out.println(getClass().getCanonicalName()+"\t"+"SCALE Y");
		for (i = -offset[0]; i <= offset[0]; i++)
			for (j = -offset[1]; j <= offset[1]; j++)
				for (k = -offset[2]; k <= offset[2]; k++) {
					values[i + offset[0]][j + offset[1]][k + offset[2]] = RegistrationUtilities.RBF3D(0, 0, 0, i, j, k, scale);
				}
		//System.out.format(valRBFM[-3+ valRBFoff][12+ valRBFoff][12+ valRBFoff] + "\n");

		maxValuesChange = 0.0;
		System.out.println(getClass().getCanonicalName()+"\t"+"SCALE Z");
		for (i = 0; i <= offset[0]; i++)
			for (j = 0; j <= offset[1]; j++)
				for (k = 0; k <= offset[2]; k++) {
					temp = Math.abs(values[i + offset[0]][j + offset[1]][k + offset[2]]
					                       - values[i - 1 + offset[0]][j + offset[1]][k + offset[2]]);
					if (temp > maxValuesChange) maxValuesChange = temp;
				}

		//System.out.format("Scale=%d\n", rbfScale);
	}
	

	public int getScale(){
		return scale;
	}
	
	public int getOffsetX(){
		return offset[0];
	}
	public int getOffsetY(){
		return offset[1];
	}
	public int getOffsetZ(){
		return offset[2];
	}
	
	public double getMaxValuesChange(){
		return maxValuesChange;
	}
	
}
