package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.io.StringReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmExtractDOTSML extends ProcessingAlgorithm{
	private ParamVolume in;
	private ParamOption atlas;
	//private ParamVolume fa; //for header
	private ParamVolume mll;
	private ParamVolume mlr;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Extract DOTS ML labels";
	private static final String longDescription = "";
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("DOTS 4D Volume",null,-1,-1,-1,-1));
		String[] sel = {"atlas 39","atlas 37"};
		inputParams.add(atlas=new ParamOption("Atlas Type", sel));
		atlas.setValue("atlas 39");
		//inputParams.add(fa=new ParamVolume("for header use",null,-1,-1,-1,-1));
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Extract DOTS ML");
		inputParams.setName("Extract_DOTS_ML");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(mll=new ParamVolume("MLL label",null,-1,-1,-1,1));
		outputParams.add(mlr=new ParamVolume("MLR label",null,-1,-1,-1,1));

	}
	protected void execute(CalculationMonitor monitor) {
		ImageData vol = in.getImageData();
		ImageHeader hdr = vol.getHeader();
		//int SCPL = 30;
		//int SCPR = 31;
		//int MCP = 21;
		//int ICPL = 15;
		//int ICPR = 16;
		int MLL, MLR;
		if(atlas.getValue().equals("atlas 39")){
			MLL = 22;
			MLR = 23;
		}
		else{
			MLL = 20;
			MLR = 21;
		}
		//ImageDataMipav labelSCPL = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
		//ImageDataMipav labelSCPR = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
		ImageDataMipav labelMLL = new ImageDataMipav(vol.getName()+"_MLL_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());

		for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelMLL.set(i, j, k, vol.getDouble(i, j, k, MLL));
				}
			}
		}
		labelMLL.setHeader(hdr);
		//mll.setName(vol.getName()+"_MLL_labels");
		mll.setValue(labelMLL);

		ImageDataMipav labelMLR = new ImageDataMipav(vol.getName()+"_MLR_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());

		for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelMLR.set(i, j, k, vol.getDouble(i, j, k, MLR));
				}
			}
		}
		labelMLR.setHeader(hdr);
		//mlr.setName(vol.getName()+"_MLR_labels");
		mlr.setValue(labelMLR);


		System.out.println("Finished");

	}
}
