package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.io.StringReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmExtractDOTSTR extends ProcessingAlgorithm{
	private ParamVolume in;
	//private ParamVolume fa; //for header
	private ParamVolume atrl;
	private ParamVolume atrr;
	private ParamVolume ptrl;
	private ParamVolume ptrr;
	private ParamVolume strl;
	private ParamVolume strr;
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Extract DOTS TR labels";
	private static final String longDescription = "";
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("DOTS 4D Volume",null,-1,-1,-1,-1));
		//inputParams.add(fa=new ParamVolume("for header use",null,-1,-1,-1,-1));
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Extract DOTS TR");
		inputParams.setName("Extract_DOTS_TR");
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(atrl=new ParamVolume("ATRL label",null,-1,-1,-1,1));
		outputParams.add(atrr=new ParamVolume("ATRR label",null,-1,-1,-1,1));
		outputParams.add(ptrl=new ParamVolume("PTRL label",null,-1,-1,-1,1));
		outputParams.add(ptrr=new ParamVolume("PTRL label",null,-1,-1,-1,1));
		outputParams.add(strl=new ParamVolume("STRL label",null,-1,-1,-1,1));
		outputParams.add(strr=new ParamVolume("STRR label",null,-1,-1,-1,1));
	}
	protected void execute(CalculationMonitor monitor) {
		ImageData vol = in.getImageData();
        ImageHeader hdr = vol.getHeader();
        int ATRL = 2;
        int ATRR = 3;
        int PTRL = 28;
        int PTRR = 29;
        int STRL = 36;
        int STRR = 37;
       
        ImageDataMipav labelATRL = new ImageDataMipav(vol.getName()+"_ATRL_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelATRR = new ImageDataMipav(vol.getName()+"_ATRR_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
    	
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelATRL.set(i, j, k, vol.getDouble(i, j, k, ATRL));
					labelATRR.set(i, j, k, vol.getDouble(i, j, k, ATRR));
				}
			}
		}
        labelATRL.setHeader(hdr);
        //atrl.setName(vol.getName()+"_ATRL_labels");
        atrl.setValue(labelATRL);
        labelATRR.setHeader(hdr);
        //atrr.setName(vol.getName()+"_ATRR_labels");
        atrr.setValue(labelATRR);
        
        ImageDataMipav labelPTRL = new ImageDataMipav(vol.getName()+"_PTRL_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelPTRR = new ImageDataMipav(vol.getName()+"_PTRR_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
    	
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelPTRL.set(i, j, k, vol.getDouble(i, j, k, PTRL));
					labelPTRR.set(i, j, k, vol.getDouble(i, j, k, PTRR));
					
				}
			}
		}
        labelPTRL.setHeader(hdr);
        //ptrl.setName(vol.getName()+"_PTRL_labels");
        ptrl.setValue(labelPTRL);
        labelPTRR.setHeader(hdr);
        //ptrr.setName(vol.getName()+"_PTRR_labels");
        ptrr.setValue(labelPTRR);
        
        ImageDataMipav labelSTRL = new ImageDataMipav(vol.getName()+"_STRL_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelSTRR = new ImageDataMipav(vol.getName()+"_STRR_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
    	
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelSTRL.set(i, j, k, vol.getDouble(i, j, k, STRL));
					labelSTRR.set(i, j, k, vol.getDouble(i, j, k, STRR));
					
				}
			}
		}
        labelSTRL.setHeader(hdr);
        //strl.setName(vol.getName()+"_STRL_labels");
        strl.setValue(labelSTRL);
        labelSTRR.setHeader(hdr);
        //strr.setName(vol.getName()+"_STRR_labels");
        strr.setValue(labelSTRR);
        System.out.println("Finished");

	}
}
