package edu.jhu.ece.iacl.plugins.dti.tractography;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Point3f;


import edu.jhu.ece.iacl.algorithms.dti.tractography.FiberStatistics;
import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
//import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
//import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
//import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
//import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.jist.structures.fiber.Fiber;
import edu.jhu.ece.iacl.jist.structures.fiber.XYZ;

public class MedicAlgorithmFiberLengthThreshold extends ProcessingAlgorithm{
	
	private ParamObject<FiberCollection> fiberset;
	private ParamDouble lowerThreshold;
	private ParamDouble upperThreshold;
	
	private ParamObject<FiberCollection> fibersetout;
	
	private FiberCollectionReaderWriter fcrw = FiberCollectionReaderWriter.getInstance();
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Fibers Thresholding";
	private static final String longDescription = "Fibers Thresholding";
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(fiberset = new ParamObject<FiberCollection>("Fiber Set to Threshold", new FiberCollectionReaderWriter()));
		inputParams.add(lowerThreshold = new ParamDouble("Lower Threshold", 20f));
		inputParams.add(upperThreshold = new ParamDouble("Upper Threshold", 80f));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI.Fiber");
		inputParams.setLabel("Fiber Length Thresholding");
		inputParams.setName("Fiber_Length_Thresholding");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setAffiliation("Johns Hopkins University, Department of Electrical and Computer Engineering");
		info.setDescription(shortDescription);
		info.setLongDescription(longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(fibersetout = new ParamObject<FiberCollection>("Fiber Set Thresholded", new FiberCollectionReaderWriter()));
	}

	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}
		System.out.println("Thresholding started");
		FiberCollection fibers = fiberset.getObject();
		
		System.out.println("Number of input fibers: " + fibers.size());
		FiberStatistics fstat = new FiberStatistics();
		fstat.setFibers(fibers);
		Point3f res = fiberset.getObject().getResolutions();
		//float []res = new float[3];
		///res[0] = fibers.getResolutions().x;
		//res[1] = fibers.getResolutions().y;
		//res[2] = fibers.getResolutions().z;
		//System.out.println(res[0]+" "+ res[1] +" "+res[2]+" ");
		if(fstat.getRes()==null){
			fstat.setRes(res.x,
					res.y,
					res.z);
		}
		fstat.computeLengths();
		ArrayList<Double> lens = fstat.getFiberLengths();
		
		System.out.println("Number of input fibers: " + fibers.size());
		FiberCollection fiberOut = new FiberCollection();
		//fiberOut.clear();
		//System.out.println("Number of input fibers: " + fibers.size());
		fiberOut.setResolutions(res);
		fiberOut.setDimensions(fibers.getDimensions());
		fiberOut.setName(fibers.getName()+"_thresholded");

		System.out.println("Resolution: " + fiberOut.getResolutions().x + " " + fiberOut.getResolutions().y + " " + fiberOut.getResolutions().z);
		
		
		int index = 0;
		for(Fiber f:fibers){
			if(lens.get(index)<= upperThreshold.getDouble() && lens.get(index)>= lowerThreshold.getDouble()){
				fiberOut.add(f);
			}
			index++;
		}
		System.out.println("Number of output fibers: " + fiberOut.size());
		
		fibersetout.setObject(fiberOut);
		System.out.println("Writing fibers");
		
		File f = writeFibers(fiberOut,dir);
		System.out.println("Thresholding finished");
	}
	
	private File writeFibers(FiberCollection fibers, File dir){
		File out = null;
		out = fcrw.write(fibers, dir);
		return out;
	}
}
