package edu.jhu.ece.iacl.plugins.dti.tractography;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import edu.jhu.ece.iacl.algorithms.manual_label.LabelImage;
import edu.jhu.ece.iacl.algorithms.manual_label.ROI;
import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.jist.structures.fiber.Fiber;
import edu.jhu.ece.iacl.jist.structures.fiber.XYZ;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;

public class MedicAlgorithmFindFACTFiberSeed extends ProcessingAlgorithm {
	//input param
	private ParamObject<FiberCollection> fiberset;

	//output param
	private ParamFile seeds;
	private ParamVolume roi;
	
	private FiberCollectionReaderWriter fcrw = FiberCollectionReaderWriter.getInstance();
	private ArrayDoubleTxtReaderWriter arw = ArrayDoubleTxtReaderWriter.getInstance();

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Gets a subset of the input fibers based on the input volumetric ROI.";
	private static final String longDescription = "";


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(fiberset = new ParamObject<FiberCollection>("Fiber Set", new FiberCollectionReaderWriter()));



		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI.Fiber");
		inputParams.setLabel("Find FACT Fiber Seed");
		inputParams.setName("Find_FACT_Fiber_Seed");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setAffiliation("Johns Hopkins University, Department of Electrical and Computer Engineering");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(seeds = new ParamFile("Volume of Labels",new FileExtensionFilter(new String[]{"csv"})) );
		outputParams.add(roi=new ParamVolume("Seeding ROI",null,-1,-1,-1,1));
	}


	@Override
	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {
		System.out.println("New");
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}

		FiberCollection fibers = fiberset.getObject();
		ImageDataMipav ROI = new ImageDataMipav(fibers.getName()+"_seeding_roi",fibers.getDimensions().x,fibers.getDimensions().y,fibers.getDimensions().z);
		ImageHeader hdr = new ImageHeader();
		float[] res = new float[3];
		res[0] = fibers.getResolutions().getX();
		res[1] = fibers.getResolutions().getY();
		res[2] = fibers.getResolutions().getZ();
		hdr.setDimResolutions(res);
		ROI.setHeader(hdr);
		int noOfFiber = 0;
		//String out = new String();
		double[][] seed = new double[fibers.size()][3];
		for(Fiber f : fibers){
			int length = f.getLength();
			for(XYZ pt : f.getChain()){
				if(pt.x-Math.floor(pt.x)==0.5 && pt.y-Math.floor(pt.y)==0.5 && pt.z-Math.floor(pt.z) == 0.5){
					seed[noOfFiber][0] = pt.x-0.5;
					seed[noOfFiber][1] = pt.y-0.5;
					seed[noOfFiber][2] = pt.z-0.5;
					ROI.set((int)Math.floor(pt.x), (int)Math.floor(pt.y), (int)Math.floor(pt.z), 1);
					break;
				}
			}
			noOfFiber++;
		}
		
		File flist = new File(dir+File.separator+"seed_list.csv");
		System.out.println(flist);
		
		arw.write(seed, flist);
		seeds.setValue(flist);
		
		roi.setValue(ROI);
	}
	private double[][] toArray(ArrayList<Integer> in ){
		double[][] out = new double[in.size()][1];
		for(int i=0; i<in.size(); i++){
			out[i][0]=in.get(i);
		}
		return out;
	}
}
