package edu.jhu.ece.iacl.plugins.utilities.array;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.jist.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.utility.ArrayUtil;



public class MedicAlgorithmArrayConcatenate extends ProcessingAlgorithm{
	private ParamFileCollection in;
	private ParamInteger dimParam;
	private ParamFileCollection out;	
	private String name;
	private static final ArrayDoubleTxtReaderWriter arw = ArrayDoubleTxtReaderWriter.getInstance();

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Concatenates Double Arrays. Can concatenate along either rows (dim=0) or columns (dim=1)." +
			"  The number or columns (rows) in each array must be identical when concatenating along rows (columns).";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.add(in=new ParamFileCollection("Array", arw.getExtensionFilter()));
		inputParams.add(dimParam=new ParamInteger("Dimension", 0));

		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.Array");
		inputParams.setLabel("Array Concatenate");
		inputParams.setName("Array_Concatenate");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(out=new ParamFileCollection("Volumes Out",arw.getExtensionFilter()));
	}


	protected void execute(CalculationMonitor monitor) {		
		File destdir = null;
		try{
			destdir = new File(this.getOutputDirectory().getCanonicalFile()+File.separator+this.getAlgorithmName());
			if(!destdir.isDirectory()){
				(new File(destdir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}
		
		name = in.getValue().get(0).getName();
		name = name.substring(0, name.lastIndexOf('.'));
		name = name + "_cat.txt";
		System.out.println(name);
		
		//get the arrays
		ArrayList<double[][]> arrays = getArrays();
		int numarrays = arrays.size();
		
		// CHECK THAT THE DIMS ARE COMPATIBLE
		int dim = dimParam.getInt();
		int numcols = -1;
		int numrows = -1;
		if(dim==0){ //concatenating along rows - check that cols work
			numrows = arrays.get(0).length;
			numcols = arrays.get(0)[0].length;
			for(int i=1; i<numarrays; i++){
				if(arrays.get(i)[0].length != numcols){
					System.err.println("Columns of input arrays are not equal");
					return;
				}
				numrows += arrays.get(i).length;
			}
		}else if(dim==1){ //concatenating along cols - check that rows work
			numrows = arrays.get(0).length;
			numcols = arrays.get(0)[0].length;
			for(int i=1; i<numarrays; i++){
				if(arrays.get(i).length != numrows){
					System.err.println("Rows of input arrays are not equal");
					return;
				}
				numcols += arrays.get(i)[0].length;
			}
		}else{
			System.err.println("Dim must equal 0 or 1");
			return;
		}
		
		// DO THE WORK
		
		double[][] arrayout = new double[numrows][numcols];
		if(dim==0){
			int r = 0;
			int nrowshere = -1;
			for(int n=0; n<numarrays; n++){
				double[][] thisarray = arrays.get(n);
				nrowshere = arrays.get(n).length;
				for(int i=0; i<nrowshere; i++){
					for(int j=0; j<numcols; j++){
						arrayout[r][j]=thisarray[i][j];
					}
					r++;
				}
			}
		}else{
			int c = 0;
			int ncolshere = -1;
//			System.out.println("numarrays: " + numarrays);
			for(int n=0; n<numarrays; n++){
				double[][] thisarray = arrays.get(n);
				ncolshere = arrays.get(n)[0].length;
				for(int j=0; j<ncolshere; j++){
					for(int i=0; i<numrows; i++){
						arrayout[i][c] = thisarray[i][j];
					}
					c++;
				}
			}
		}
		
		
		//OUTPUT
        File fileout = new File(destdir+File.separator+name);
        File filewritten = arw.write(arrayout, fileout);
        out.add(filewritten);
	}
	
	private ArrayList<double[][]> getArrays(){
		List<File> filelist = in.getValue();
		ArrayList<double[][]> arrays = new ArrayList<double[][]>(filelist.size());
		for(File f: filelist){ arrays.add(arw.read(f)); }
		return arrays;
	}
}
