package edu.jhu.ece.iacl.plugins.utilities.file;

import java.io.File;
import java.io.IOException;

import Jama.Matrix;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleMtxReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamMatrix;

public class MatrixParamToMatrixFile extends ProcessingAlgorithm {

	ParamFile fileout;
	ParamFile filein;
	
	ParamMatrix mtxout;
	ParamMatrix mtxin;

	private ArrayDoubleMtxReaderWriter rw = new ArrayDoubleMtxReaderWriter();

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	String shortDescription = "Converts a ParamMatrix to a .mtx file or vice versa";
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(filein = new ParamFile("Matrix file in"));
		filein.setMandatory(false);
		Matrix m = new Matrix(4,4);
		inputParams.add(mtxin = new ParamMatrix("Matrix parameter in",m));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.File");
		inputParams.setLabel("Matrix Convert");
		inputParams.setName("Matrix_Convert");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("IACL","John Bogovic",""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(fileout = new ParamFile("Matrix file out"));
		fileout.setMandatory(false);
		Matrix m = new Matrix(4,4);
		outputParams.add(mtxout = new ParamMatrix("Matrix parameter out",m));

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		
		if(filein.getValue()!=null){
			ArrayDoubleMtxReaderWriter rw = new ArrayDoubleMtxReaderWriter();
			double[][] xfm = rw.read(filein.getValue());
			Matrix mout = new Matrix(4,4);
			for(int i=0; i<4; i++){
				for(int j=0; j<4; j++){
					mout.set(i, j, xfm[i][j]);
				}
			}
			mtxout.setValue(mout);
		}else{
			Matrix m = mtxin.getValue();
			double[][] xfmout = new double[4][4];
			for(int i=0; i<4; i++){
				for(int j=0; j<4; j++){
					xfmout[i][j] = m.get(i, j);
				}
			}
			File f = new File(dir+File.separator+"transformationMatrix.mtx");
			File fout = rw.write(xfmout, f);
			fileout.setValue(fout);
		}
		
	}
	

}
