package edu.vanderbilt.VUIIS.algorithms;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class CESTCalc {

	public double[][][] getS0avg(ImageData imageVol, boolean[] baseline){
		int r = imageVol.getRows();
		int c = imageVol.getCols();
		int s = imageVol.getSlices();
		int t = imageVol.getComponents();
		int count = 0;
		double[][][] s0 = new double[r][c][s];
		for(int m=0;m<t;m++){
			if(baseline[m]){
				for(int i=0;i<r;i++){
					for(int j=0;j<c;j++){
						for(int k=0;k<s;k++){
							s0[i][j][k] = s0[i][j][k]+imageVol.getDouble(i,j,k,m);
						}
					}
				}
				count++;
			}
		}
		for(int i=0;i<r;i++){
			for(int j=0;j<c;j++){
				for(int k=0;k<s;k++){
					s0[i][j][k] = s0[i][j][k]/count;
				}
			}
		}
		return s0;
	}
	
	public double[][][] getS0avg_fromREF(ImageData ref){
		int rref = ref.getRows();
		int cref = ref.getCols();
		int sref = ref.getSlices();
		int tref = ref.getComponents();
		double [][][] refavg = new double[rref][cref][sref];
		for(int i=0;i<rref;i++){	
			for(int j=0;j<cref;j++){
				for(int k=0;k<sref;k++){
					for(int m=0;m<tref;m++){
						refavg[i][j][k] = refavg[i][j][k] + ref.getDouble(i,j,k,m);
					}
				}
			}
		}
		for(int i=0;i<rref;i++){	
			for(int j=0;j<cref;j++){
				for(int k=0;k<sref;k++){
					refavg[i][j][k] = refavg[i][j][k]/tref;
				}
			}
		}
		return refavg;
	}
	
	public ImageData getS(ImageData imageVol, boolean[] baseline){
		int r = imageVol.getRows();
		int c = imageVol.getCols();
		int s = imageVol.getSlices();
		int t = imageVol.getComponents();
		int count = 0;
		for(int i=0;i<baseline.length;i++){
			if(baseline[i])
				count++;
		}
		int ts = t-count;
		ImageData S = new ImageDataFloat(r,c,s,ts);
		int idx = 0;
		for(int m=0;m<t;m++){
			if(!baseline[m]){
				for(int i=0;i<r;i++){
					for(int j=0;j<c;j++){
						for(int k=0;k<s;k++){
							S.set(i,j,k,idx,imageVol.getDouble(i,j,k,m));
						}
					}
				}
				idx++;
			}
		}
		return S;
	}
	
	public ImageData getS0(ImageData imageVol, boolean[] baseline){
		int r = imageVol.getRows();
		int c = imageVol.getCols();
		int s = imageVol.getSlices();
		int t = imageVol.getComponents();
		int count = 0;
		for(int i=0;i<baseline.length;i++){
			if(baseline[i])
				count++;
		}
		int ts = count;
		ImageData S0 = new ImageDataFloat(r,c,s,ts);
		int idx = 0;
		for(int m=0;m<t;m++){
			if(baseline[m]){
				for(int i=0;i<r;i++){
					for(int j=0;j<c;j++){
						for(int k=0;k<s;k++){
							S0.set(i,j,k,idx,imageVol.getDouble(i,j,k,m));
						}
					}
				}
				idx++;
			}
		}
		return S0;
	}
}