package edu.vanderbilt.VUIIS.algorithms;

import edu.jhu.bme.smile.commons.math.Spline;
import edu.jhu.bme.smile.commons.optimize.BrentMethod1D;
import edu.jhu.bme.smile.commons.optimize.DownhillSimplexND;
import edu.jhu.bme.smile.commons.optimize.FunctionNumeric1DDifferentiation;
import edu.jhu.bme.smile.commons.optimize.GoldenSectionSearch1D;
import edu.jhu.bme.smile.commons.optimize.NewtonMethod1D;
import edu.jhu.bme.smile.commons.optimize.Optimizable1DContinuous;
import edu.jhu.bme.smile.commons.optimize.Optimizable1DContinuousDifferentiable;
import edu.jhu.bme.smile.commons.optimize.OptimizableNDContinuous;
import edu.jhu.bme.smile.commons.optimize.Optimizer1DContinuous;
import edu.jhu.bme.smile.commons.optimize.Optimizer1DContinuousDifferentiable;
import edu.jhu.bme.smile.commons.optimize.OptimizerNDContinuous;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;


public class InterpMinCalc {
	
	
	public double interpmin(double[] x, double[] y, int interp){
		Spline func = new Spline(x,y);
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<x.length;i++) {
			max = (max<x[i]?x[i]:max);
			min = (min>x[i]?x[i]:min);
		}
		double delta = 2*max/(interp-1);
		double interpy = 0;
		double interpx = 0;
		double interpmin = Double.MAX_VALUE;
		double index = 0;
		for(int idx=0;idx<interp;idx++){
			interpx = min + delta*idx;
			interpy = func.spline_value(interpx);
			index = (interpmin>interpy?interpx:index);
			interpmin = (interpmin>interpy?interpy:interpmin);
		}
		return index;
	}
}
