package edu.vanderbilt.VUIIS.plugins;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

import edu.jhu.bme.smile.commons.math.Spline;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parser.MipavPluginParser;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRT;
import edu.vanderbilt.VUIIS.algorithms.GaussianFunction;
import gov.nih.mipav.view.dialogs.ActionDiscovery;


public class GaussianCurve extends ProcessingAlgorithm{
	/****************************************************
	 * Declare Input Parameters
	 ****************************************************/
	private ParamFloat mean;
	private ParamFloat stdDev;
	private ParamInteger N;
		
	/****************************************************
	 * Declare Output Parameters
	 ****************************************************/
	private ParamFile gaussian;

	/****************************************************
	 * Declare Plugin Information Variables
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Demons Registration for CEST Volumes";
	private static final String longDescription = "\nInput 1: 4-D CEST Volume (x,y,z,t): " +
	" [rows,columns,slices,offset frequencies] " +
	"\nInput 2: 3-D Anatomical Volume (x,y,z):" +
	" [rows,columns,slices]"+
	"\nOutput 1: 4-D Registered CEST Volume (x,y,z,t): " +
	" [rows,columns,slices,offset frequencies]" +
	"\nOutput 2: Execution Time [sec]; " +
	"\n\tThe time to run the algorithm.";


	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Set Plugin Information
		 ****************************************************/
		inputParams.setPackage("VUIIS");
		inputParams.setCategory("Utilities");
		inputParams.setLabel("Gaussian Curve");
		inputParams.setName("Gaussian Curve");

		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Blake Dewey","blake.e.dewey@vanderbilt.edu",""));
		info.setAffiliation("Vanderbilt University");
		info.setDescription(shortDescription + longDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.add(new Citation(""));
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);

		/****************************************************
		 * Add input parameters to control system
		 ****************************************************/
		inputParams.add(mean = new ParamFloat("Mean",0));
		inputParams.add(stdDev = new ParamFloat("Standard Deviation",1));
		inputParams.add(N = new ParamInteger("Number of Points",50));

	}


	protected void createOutputParameters(ParamCollection outputParams) {
		/****************************************************
		 * Add output parameters to control system
		 ****************************************************/
		outputParams.add(gaussian = new ParamFile("Gaussian Values",new FileExtensionFilter(new String[]{"xls"})));
		
		
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		/****************************************************
		 * Create a Wrapper to Enclose the Algorithm
		 ****************************************************/
		AlgorithmWrapper wrapper=new AlgorithmWrapper();
		monitor.observe(wrapper);
		wrapper.execute(this);
	}
	

	protected class AlgorithmWrapper extends AbstractCalculation {
		protected void execute(ProcessingAlgorithm parent) {
			this.setLabel("PARSING INPUTS");
			
			/****************************************************
			 * Indicate that the Plugin has started.
			 ****************************************************/
			JistLogger.logOutput(JistLogger.INFO, "PLUGIN STARTED");
			
			/****************************************************
			 * Parse the input data
			 ****************************************************/
			
			/****************************************************
			 * Setup memory for the computed volumes
			 ****************************************************/
			
			/****************************************************
			 * Run the core algorithm(s).
			 ****************************************************/
			this.setLabel("CREATE CURVE");
			
			double[] y = new double[N.getInt()];
			GaussianFunction gauss = new GaussianFunction();
			y = gauss.createGaussianCurve(stdDev.getDouble(),mean.getDouble(),N.getInt());
			
			
			String f = getOutputDirectory().getAbsoluteFile().toString();
			File gauss_file = new File(f+"/"+ gaussian.getName()+".xls");
			try {
				BufferedWriter data=new BufferedWriter(new FileWriter(gauss_file));
				int n = y.length;
				for(int j=0;j<n;j++){
					data.append(y[j]+"");
					data.append("\n");
				} 
					data.close();
				} catch (IOException e) {
					System.err.println(getClass().getCanonicalName()+e.getMessage());
					return;
				}	


			/****************************************************
			 * Retrieve the image data and put it into a new
			 * data structure.
			 ****************************************************/
			JistLogger.logOutput(JistLogger.INFO, "SETTING UP EXPORTS");
			gaussian.setValue(gauss_file);
			JistLogger.logOutput(JistLogger.INFO, "FINISHED");
		}
	}
}
