package edu.vanderbilt.masi.algorithms.adaboost;

import org.json.*;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;

public abstract class WeakLearner extends AbstractCalculation {
	
	protected double alpha;
	protected double rate;
	
	public abstract void reset();
	public abstract String get_type();
	public abstract int get_num_elements();
	public abstract void get_vals(double [] vals);
	public abstract void set_vals(double [] vals);
	public abstract double [] get_parms();
	public abstract void find_best_learner(boolean [] Y,
			  							   float [][] X,
			  							   int [][] sort_inds,
			  							   double [] W,
			  							   int num_samples_total,
			  							   int num_features);
	public abstract int classify(float [][] X, int ind);
	public abstract void print_info(int iter, double error);
	public abstract String get_criterion_string();
	
	public JSONObject toJSON() {
		JSONObject obj;
		try {

			// set the input parameters
			double [] parms = get_parms();
			JSONArray json_parms = new JSONArray();
			for (int i = 0; i < parms.length; i++)
				json_parms.put(parms[i]);
			
			// set the values
			double [] vals = get_vals();
			JSONArray json_vals = new JSONArray();
			for (int i = 0; i < vals.length; i++)
				json_vals.put(vals[i]);
			
			obj = new JSONObject();
			obj.put("Type", get_type());
			obj.put("Parameters", json_parms);
			obj.put("Values", json_vals);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException("JSON Exception encountered.");
		}
		
		return(obj);
	}
	
	public static WeakLearner getInstance(JSONObject obj) {
		
		WeakLearner wl;
		
		try {
			
			// get the parameters for this learner
			JSONArray json_parms = obj.getJSONArray("Parameters");
			double [] parms = new double [json_parms.length()];
			for (int i = 0; i < parms.length; i++)
				parms[i] = json_parms.getDouble(i);
			
			// determine the learner type and pass the parameters
			String type = obj.getString("Type");
			if (type.equals(WeakLearnerDecisionStump.TYPE))
				wl = new WeakLearnerDecisionStump(parms);
			else if (type.equals(WeakLearnerDecisionTree.TYPE))
				wl = new WeakLearnerDecisionTree(parms);
			else
				throw new RuntimeException("Invalid Weak Learner Type: " + type);
			
			// set the values for this learner
			JSONArray json_vals = obj.getJSONArray("Values");
			double [] vals = new double [json_vals.length()];
			for (int i = 0; i < vals.length; i++)
				vals[i] = json_vals.getDouble(i);
			wl.set_vals(vals);
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException("JSON Exception encountered.");
		}
		
		return(wl);
	}
	
	public void set_alpha() {
		if (rate < 0.00001)
			rate = 0.00001;
		if (rate > 0.99999)
			rate = 0.99999;
		alpha = (0.5 * Math.log(rate / (1 - rate)));
	}
	public double get_alpha() { return(alpha); }
	public double get_rate() { return(rate); }
	public double [] get_vals() {
		double [] vals = new double [get_num_elements()];
		get_vals(vals);
		return(vals);
	}
}
