package edu.vanderbilt.masi.algorithms.clasisfication;

import java.util.ArrayList;
import java.util.HashMap;

public class DistanceFeatureCalculator extends FeatureCalculator {
	
	private ArrayList<float[]> locations;
	private ArrayList<String> names;
	
	public DistanceFeatureCalculator(int[][][] im){
		HashMap<Integer,ArrayList<VolumeLocation>> maps = new HashMap<Integer,ArrayList<VolumeLocation>>(500,(float)0.3);
		for(int i=0;i<im.length;i++){
			for(int j=0;j<im[0].length;j++){
				for(int k=0;k<im[0][0].length;k++){
					int l = im[i][j][k];
					if(!maps.containsKey(l)) maps.put(l,new ArrayList<VolumeLocation>(100000));
					ArrayList<VolumeLocation> v = maps.get(l);
					v.add(new VolumeLocation(i,j,k));
					maps.put(l, v);
				}
			}
		}
		this.locations = new ArrayList<float[]>(maps.size());
		this.names = new ArrayList<String>(4*maps.size());
		for(int i:maps.keySet()){
			this.names.add("Distance to label "+i);
			this.names.add("Dx to label "+i);
			this.names.add("Dy to label " +i);
			this.names.add("Dz to label "+i);
			ArrayList<VolumeLocation> V = maps.get(i);
			float x=0;
			float y=0;
			float z=0;
			for(VolumeLocation v:V){
				x += v.getX();
				y += v.getY();
				z += v.getZ();
			}
			float[] n = new float[3];
			n[0] = x/V.size();
			n[1] = y/V.size();
			n[2] = z/V.size();
			this.locations.add(n);
		}
	}

	@Override
	public ArrayList<Float> calculateFeatures(float[][][] im, int r, int c,
			int s) {
		return null;
	}

	@Override
	public ArrayList<Float> calculateFeatures(int[][][] im, int r, int c, int s) {
		ArrayList<Float> features = new ArrayList<Float>(this.names.size());
		for(int i=0;i<this.locations.size();i++){
			float[] loc = this.locations.get(i);
			float f = (float) Math.sqrt(((r-loc[0])*(r-loc[0]))+((c-loc[1])*(c-loc[1]))+((s-loc[2])*(s-loc[2])));
			features.add(f);
			f = (float) r-loc[0];
			features.add(f);
			f = (float) c-loc[1];
			features.add(f);
			f = (float) s-loc[2];
			features.add(f);
		}
		return features;
	}

	@Override
	public ArrayList<String> getFeatureNames() {
		return this.names;
	}

	@Override
	public boolean takesIntensity() {
		return false;
	}

	@Override
	public boolean takesLabels() {
		return true;
	}

}
