package edu.vanderbilt.masi.algorithms.clasisfication;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;

import edu.jhu.ece.iacl.jist.utility.JistLogger;
import org.json.*;


public class FeatureCalculationRunner {

	private ArrayList<FeatureCalculator> calculators;
	private ArrayList<String> feature_names;
//	private ImageDataFloat features;
	private float[][] features;
	private ArrayList<Integer> xs;
	private ArrayList<Integer> ys;
	private ArrayList<Integer> zs;
	private int[][][] label_volume;
	
	public FeatureCalculationRunner(){
		this.calculators = new ArrayList<FeatureCalculator>();
		this.feature_names = new ArrayList<String>();
	}
	
	public void addCalculator(FeatureCalculator FC){
		this.calculators.add(FC);
		this.feature_names.addAll(FC.getFeatureNames());
	}
	
	public void calculateFeatures(float[][][] intensity, int[][][] labels, boolean[][][] mask){
		this.label_volume = labels;
		int num = 0;
		int r = mask.length;
		int c = mask[0].length;
		int s = mask[0][0].length;
		JistLogger.logOutput(JistLogger.INFO, "Allocating Memory");
		for(int i=0;i<r;i++){
			for(int j=0;j<c;j++){
				for(int k=0;k<s;k++){
					if(mask[i][j][k])num++;
				}
			}
		}
		this.features = new float[num][this.feature_names.size()];
		this.xs = new ArrayList<Integer>(num);
		this.ys = new ArrayList<Integer>(num);
		this.zs = new ArrayList<Integer>(num);
		num = 0;
		ArrayList<Float> temp_features;
		JistLogger.logOutput(JistLogger.INFO,"Starting Feature Calculation");
		for(int i=0;i<r;i++){
			for(int j=0;j<c;j++){
				for(int k=0;k<s;k++){
					if(mask[i][j][k]){
						xs.add(i);
						ys.add(j);
						zs.add(k);
						if(num%10000==0){ 
							JistLogger.logOutput(JistLogger.FINE, "On voxel "+num+" out of "+this.features.length);
							JistLogger.logFlush();
						}
						temp_features = new ArrayList<Float>();
						for(FeatureCalculator FC: this.calculators){
							if(FC.takesIntensity()){
								temp_features.addAll(FC.calculateFeatures(intensity, i, j, k));
							}else if(FC.takesLabels()){
								temp_features.addAll(FC.calculateFeatures(labels,i,j,k));
							}
						}
						for(int l=0;l<temp_features.size();l++) {
							this.features[num][l] = temp_features.get(l);
						}
						num++;
					}
				}
			}
		}
	}
	
	public void writeFile(File f){
		JistLogger.logOutput(JistLogger.INFO, "output file is "+f.getAbsolutePath());
		try{
			FileOutputStream fstream = new FileOutputStream(f);
			OutputStreamWriter ow;
			if(f.getAbsolutePath().endsWith("gz"))	ow = new OutputStreamWriter(new GZIPOutputStream(fstream),"utf-8");
			else  ow = new OutputStreamWriter(fstream);
			BufferedWriter bw = new BufferedWriter(ow);
			JSONObject row;
			ArrayList<Float> temp;
			row = new JSONObject();
			row.put("feature_names", this.feature_names);
			row.put("number", this.features.length);
			bw.write(row.toString());
			bw.write("\n");
			for(int i=0;i<this.features.length;i++){
				row = new JSONObject();
				row.put("x", xs.get(i));
				row.put("y", ys.get(i));
				row.put("z", zs.get(i));
				row.put("label", this.label_volume[xs.get(i)][ys.get(i)][zs.get(i)]);
				temp = new ArrayList<Float>(this.features[i].length);
				for(int j=0;j<this.features[i].length;j++) temp.add(this.features[i][j]);
				row.put("features", temp);
				bw.write(row.toString());
				bw.write("\n");
			}
			bw.close();
			ow.close();
			fstream.close();
		}catch(IOException e){
			e.printStackTrace();
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
}
