package edu.vanderbilt.masi.algorithms.clasisfication;

import java.util.ArrayList;
import java.util.HashMap;

public class LabelFeatureCalculator extends FeatureCalculator {
	
	private int radius;
	private HashMap<Integer,Integer> labels;
	
	public LabelFeatureCalculator(int[][][] label_im, int radius){
		this.radius = radius;
		this.labels = new HashMap<Integer,Integer>();
		this.names = new ArrayList<String>();
		int n = 0;
		for(int i=0;i<label_im.length;i++){
			for(int j=0;j<label_im[0].length;j++){
				for(int k=0;k<label_im[0][0].length;k++){
					if(!this.labels.containsKey(label_im[i][j][k])){
						this.labels.put(label_im[i][j][k],n);
						this.names.add("Count of label "+label_im[i][j][k]+ " within radius of "+this.radius);
						n++;
					}
				}
			}
		}
		System.out.println("There were "+this.labels.size()+ " labels found");
		
	}

	public ArrayList<Float> calculateFeatures(int[][][] im, int r, int c,
			int s) {
		ArrayList<Float> features = new ArrayList<Float>(this.names.size());
		for(int i=0;i<this.names.size();i++) features.add((float) 0.0);
		int xl = Math.max(0, r-radius);
		int xh = Math.min(r+radius, im.length-1);
		int yl = Math.max(0, c-radius);
		int yh = Math.min(c+radius, im[0].length-1);
		int zl = Math.max(0, s-radius);
		int zh = Math.min(s+radius, im[0][0].length-1);
		int label;
		for(int i=xl;i<xh;i++){
			for(int j=yl;j<yh;j++){
				for(int k=zl;k<zh;k++){
					label = im[i][j][k];
					features.set(this.labels.get(label),features.get(this.labels.get(label))+1);
				}
			}
		}
		return features;
	}

	@Override
	public ArrayList<String> getFeatureNames() {
		
		return this.names;
	}

	@Override
	public ArrayList<Float> calculateFeatures(float[][][] im, int r, int c,
			int s) {
		return null;
	}

	@Override
	public boolean takesIntensity() {
		return false;
	}

	@Override
	public boolean takesLabels() {
		return true;
	}

}
