package edu.vanderbilt.masi.algorithms.clasisfication;

public class VolumeLocation implements Comparable<VolumeLocation> {

	private int x;
	private int y;
	private int z;
	
	public VolumeLocation(int x, int y, int z){
		this.x = x;
		this.y = y;
		this.z = z;
	}
	
	public int getX(){ return this.x; }
	public int getY(){ return this.y; }
	public int getZ(){ return this.z; }

	@Override
	public int compareTo(VolumeLocation o) {
		if(this.x < o.getX()) return 1;
		else if(this.x > o.getX()) return -1;
		else if(this.y < o.getY()) return 1;
		else if(this.y > o.getY()) return -1;
		else if(this.z < o.getZ()) return 1;
		else if(this.z > o.getZ()) return -1;
		return 0;
	}
	
	@Override
	public int hashCode() {
	    final int prime = 31;
	    int result = 1;
	    result = prime * result + (int) (x ^ 17);
	    result = prime * result + (int) (y ^ 13);
	    result = prime * result + (int) (z ^ 19);
	    return result;
	}

}
