package edu.vanderbilt.masi.algorithms.dti;

import java.io.File;

public class DWIParams {
	
	protected File listFile;
	protected File dataFile;
	protected boolean zoom;
	protected String shotmode;
	protected int nNSA;
	protected int nCOIL;
	protected int[] FOV;		//FH, RL, AP
	protected float acq_vox_m;
	protected float slice_thickness;
	protected int ACQ_RESOL;
	protected int RECON_RESOL;
	protected int SENSE_FACTOR;
	protected int nSLICE;
	protected int slice_gap;
	protected String slice_orientation;
	protected String fold_over_dir;
	protected String fat_shift_dir;
	protected int chunks;
	protected float[] Offc;		//FH, RL, AP
	protected float[] Ang;		//FH, RL, AP
	protected boolean isEPI;
	protected String scan_mode;
	protected String technique;
	protected int[] EPI_FACTOR;
	protected int nEC;
	protected boolean halfscan;
	protected String diff_mode;
	protected int nROW;
	protected String directional_resolution;
	protected boolean gradient_overplus;
	protected float[][][] DW_GRAD;
	protected int nDW_GRAD;
	protected int[] trb;
	protected int UGN1_ACQ_reduced_acq_time;
	protected int STD_start_sign;
	protected int PHC_start_sign;
	protected String loadDir_s;
	protected float acq_vox_p;
	protected int nSHOT;
	
	
	public DWIParams(File listFile,File dataFile,boolean zoom,String shotmode,int nNSA,
			int nCOIL,int[] FOV,float acq_vox_m,float slice_thickness,int ACQ_RESOL,
			int RECON_RESOL,int SENSE_FACTOR,int nSLICE,int slice_gap,
			String slice_orientation,String fold_over_dir,String fat_shift_dir,
			int chunks,float[] Offc,float[] Ang,boolean isEPI,String scan_mode,
			String technique,int[] EPI_FACTOR,int nEC,boolean halfscan,String diff_mode,
			int nROW,String directional_resolution,boolean gradient_overplus,
			float[][][] DW_GRAD,int nDW_GRAD,int[] trb,int UGN1_ACQ_reduced_acq_time,
			int STD_start_sign,int PHC_start_sign,String loadDir_s,float acq_vox_p,
			int nSHOT){
		this.listFile = listFile;
		this.dataFile = dataFile;
		this.zoom = zoom;
		this.shotmode = shotmode;
		this.nNSA = nNSA;
		this.nCOIL = nCOIL;
		this.FOV = FOV; 
		this.acq_vox_m = acq_vox_m;
		this.slice_thickness = slice_thickness;
		this.ACQ_RESOL = ACQ_RESOL;
		this.RECON_RESOL = RECON_RESOL;
		this.SENSE_FACTOR = SENSE_FACTOR;
		this.nSLICE = nSLICE; 
		this.slice_gap = slice_gap;
		this.slice_orientation = slice_orientation;
		this.fold_over_dir = fold_over_dir;
		this.fat_shift_dir = fat_shift_dir;
		this.chunks = chunks;
		this.Offc = Offc;
		this.Ang = Ang;
		this.isEPI = isEPI;
		this.scan_mode = scan_mode;
		this.technique = technique; 
		this.EPI_FACTOR = EPI_FACTOR;
		this.nEC = nEC;
		this.halfscan = halfscan;
		this.diff_mode = diff_mode;
		this.nROW = nROW;
		this.directional_resolution = directional_resolution;
		this.gradient_overplus = gradient_overplus;
		this.DW_GRAD = DW_GRAD;
		this.nDW_GRAD = nDW_GRAD;
		this.trb = trb;
		this.UGN1_ACQ_reduced_acq_time = UGN1_ACQ_reduced_acq_time;
		this.STD_start_sign = STD_start_sign;
		this.PHC_start_sign = PHC_start_sign;
		this.loadDir_s = loadDir_s;
		this.acq_vox_p = acq_vox_p;
		this.nSHOT = nSHOT;
	}
	
	
	public File get_listFile(){
		return this.listFile;
	}
	public File get_dataFile(){
		return this.dataFile;
	}
	public boolean get_zoom(){
		return this.zoom;
	}
	public String get_shotmode(){
		return this.shotmode;
	}
	public int get_nNSA(){
		return this.nNSA;
	}
	public int get_nCOIL(){
		return this.nCOIL;
	}
	public int[] get_FOV(){
		return this.FOV;
	}
	public float get_acq_vox_m(){
		return this.acq_vox_m;
	}
	public float get_slice_thickness(){
		return this.slice_thickness;
	}
	public int get_ACQ_RESOL(){
		return this.ACQ_RESOL;
	}
	public int get_RECON_RESOL(){
		return this.RECON_RESOL;
	}
	public int get_SENSE_FACTOR(){
		return this.SENSE_FACTOR;
	}
	public int get_nSLICE(){
		return this.nSLICE;
	}
	public int get_slice_gap(){
		return this.slice_gap;
	}
	public String get_slice_orientation(){
		return this.slice_orientation;
	}
	public String get_fold_over_dir(){
		return this.fold_over_dir;
	}
	public String get_fat_shift_dir(){
		return this.fat_shift_dir;
	}
	public int get_chunks(){
		return this.chunks;
	}
	public float[] get_Offc(){
		return this.Offc;
	}
	public float[] get_Ang(){
		return this.Ang;
	}
	public boolean get_isEPI(){
		return this.isEPI;
	}
	public String get_scan_mode(){
		return this.scan_mode;
	}
	public String get_technique(){
		return this.technique;
	}
	public int[] get_EPI_FACTOR(){
		return this.EPI_FACTOR;
	}
	public int get_nEC(){
		return this.nEC;
	}
	public boolean get_halfscan(){
		return this.halfscan;
	}
	public String get_diff_mode(){
		return this.diff_mode;
	}
	public int get_nROW(){
		return this.nROW;
	}
	public String get_directional_resolution(){
		return this.directional_resolution;
	}
	public boolean get_gradient_overplus(){
		return this.gradient_overplus;
	}
	public float[][][] get_DW_GRAD(){
		return this.DW_GRAD;
	}
	public int get_nDW_GRAD(){
		return this.nDW_GRAD;
	}
	public int[] get_trb(){
		return this.trb;
	}
	public int get_UGN1_ACQ_reduced_acq_time(){
		return this.UGN1_ACQ_reduced_acq_time;
	}
	public int get_STD_start_sign(){
		return this.STD_start_sign;
	}
	public int get_PHC_start_sign(){
		return this.PHC_start_sign;
	}
	public String get_loadDir_s(){
		return this.loadDir_s;
	}
	public float get_acq_vox_p(){
		return this.acq_vox_p;
	}
	public int get_nSHOT(){
		return this.nSHOT;
	}

}
