package edu.vanderbilt.masi.algorithms.dti;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;



public class ExamCardParser3T {
	File examcard;
	Document doc;
	final protected String basePath="/dump/folder/examcard";
	/**
	 * Reference scan information
	 */
	String refScanName;
	int[] refFOV = new int[3];
	float[] refAcquiredVoxels=new float[3];
	float refSliceThickness;
	boolean refFoldOverSupression;
	String refSliceOrientation;
	String refFoldOverDirection;
	String refFatShiftDir;
	float[] refOffCenter=new float[3];			//AP/RL/FH
	float[] refAngulation=new float[3];			//AP/RL/FH
	int refNumberOfSlices;
	
	//These aren't in the exam card
	int refOverscanM;
	int refOverscanP;
	int refNumCoils;
	int refBodyCoilInd;
	
	/**
	 * DWI scan information
	 */
	String dwiTechnique;
	String dwiScanName;
	Boolean dwiZOOM;
	String dwiShotMode;
	int dwiNumSlices;
	int dwiNSA;
	int[] dwiAcqMtrxMP = new int[2];
	int dwiNumCoil;
	float[] dwiFOV = new float[3];
	int dwiAcqVoxM;
	float[] dwiAcqVox = new float[3];
	float dwiSliceThickness;
	int dwiReconRes;
	int dwiSenseFact;
	float dwiSliceGap;
	String dwiSliceOrientation;
	String dwiFoldOverDirection;
	String dwiFatShiftDir;
	String dwiScanMode;
	float[] dwiOffCenter=new float[3];
	float[] dwiAngulation= new float[3];
	int[] dwiEPIFactor = new int[2];
	int[] dwiTRB = new int[2];
	float[] dwiBW = new float[2];
	int navEPIFactor=0;
	int dwiNumEchoes;
	String dwiDiffMode;
	String dwiDirectionalResolution;
	boolean dwiHalfscan;
	int dwiNumberOfBValues;
	boolean dwiGradientOverplus;
	int dwiAcqReducedAcqTime;
	
	
	public ExamCardParser3T(){
	}
	
	public ExamCardParser3T(File f){
		this.examcard = f;
	}
	
	public ExamCardParser3T(File f,String dwiScanName){
		this.examcard = f;
		this.dwiScanName = dwiScanName;
	}
	
	//Default constructor to set the file and init
	public ExamCardParser3T(File f,String dwiScanName,String refScanName) throws ParserConfigurationException, SAXException, IOException{
		this.examcard = f;
		this.dwiScanName = dwiScanName;
		this.refScanName = refScanName;
		init();
	}
	
	/**
	 * init the xml document
	 */
	private void init() throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		doc = builder.parse(examcard);
	}
	
	/**
	 * Method to parse all the reference scan params.
	 * @throws XPathExpressionException
	 * @throws ExamCardParserException
	 */
	public void parseRef() throws XPathExpressionException, ExamCardParserException{
		
		XPath xPath =  XPathFactory.newInstance().newXPath();
		
		System.out.println("%%%%Begin REF Params%%%%");
		//FH FOV
		XPathExpression expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='FOV          FH (mm)']/@value");
		Object result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF FH FOV ->%d\n",Integer.valueOf(result.toString()));
		refFOV[0]= Integer.valueOf(result.toString());
		
		
		//RL FOV
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='FOV          FH (mm)']/subparameter[@name='RL (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF RL FOV ->%d\n",Integer.valueOf(result.toString()));
		refFOV[1]= Integer.valueOf(result.toString());
		
		
		//AP FOV
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='FOV          FH (mm)']/subparameter[@name='stack    AP (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF AP FOV ->%d\n",Integer.valueOf(result.toString()));
		refFOV[2]= Integer.valueOf(result.toString());
		
		//FH Voxel Size
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Voxel size   FH (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF FH Voxel Size ->%f\n",Float.valueOf(result.toString()));
		refAcquiredVoxels[0]= Float.valueOf(result.toString());
		
		//RL Voxel Size
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Voxel size   FH (mm)']/subparameter[@name='RL (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF RL Voxel Size %f\n",Float.valueOf(result.toString()));
		refAcquiredVoxels[1]= Float.valueOf(result.toString());
		
		//AP Voxel Size
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Voxel size   FH (mm)']/subparameter[@name='AP (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF AP Voxel Size ->%f\n",Float.valueOf(result.toString()));
		refAcquiredVoxels[2]= Float.valueOf(result.toString());
		
		//Slice Thickness
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Voxel size   FH (mm)']/subparameter[@name='AP (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF Slice Thickness ->%d\n",Integer.valueOf(result.toString()));
		refSliceThickness = Integer.valueOf(result.toString());
		
		//Fold over supression
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Fold-over suppression']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF Fold Over Suppression ->%s\n",result.toString());
		if (result.toString().equals("yes")){
			refFoldOverSupression = true;
		}else if (result.toString().equals("no")){
			refFoldOverSupression = false;
		}else{
			throw new ExamCardParserException("Error: Fold over suppression value could not be parsed.");
		}
		//Number of Slices
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='slices']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF Number of slices ->%d\n",Integer.valueOf(result.toString()));
		refNumberOfSlices = Integer.valueOf(result.toString());
				
		//Slice orientation
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='slice orientation']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF Slice orientation ->%s\n", result.toString());
		refSliceOrientation = result.toString();
		
		//Fold over Direction
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='fold-over direction']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF Fold over direction ->%s\n", result.toString());
		refFoldOverDirection = result.toString();
		
		//Fat shift direction
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='fat shift direction']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF fat shift direction ->%s\n", result.toString());
		refFatShiftDir=result.toString();
		
		//Off Center AP
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF offcenter AP ->%f\n", Float.valueOf(result.toString()));
		refOffCenter[2]= Float.valueOf(result.toString());
		
		//Off Center RL
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='RL (L=+mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF offcenter RL ->%f\n", Float.valueOf(result.toString()));
		refOffCenter[1] = Float.valueOf(result.toString());
		
		//Off Center FH
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='FH (H=+mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF offcenter FH ->%f\n", Float.valueOf(result.toString()));
		refOffCenter[0] = Float.valueOf(result.toString());
		
		//Angulation AP
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='Ang.  AP (deg)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF angulation AP ->%f\n", Float.valueOf(result.toString()));
		refAngulation[2]= Float.valueOf(result.toString());
		
		//Angulation RL
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='RL (deg)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF angulation RL ->%f\n", Float.valueOf(result.toString()));
		refAngulation[1] = Float.valueOf(result.toString());
		
		//Angulation FH
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='FH (deg)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("REF angulation FH ->%f \n", Float.valueOf(result.toString()));
		refAngulation[0] = Float.valueOf(result.toString());
		
		
		

	}
	
	public void parseDWI() throws XPathExpressionException, ExamCardParserException{
		
		XPath xPath =  XPathFactory.newInstance().newXPath();
		
		//*********************************************************************************
		//***************************************CONTRAT***********************************
		//*********************************************************************************
		//Scan Mode
		XPathExpression expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Scan mode']/@value");
		Object result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI scan mode ->%s\n",result.toString());
		dwiScanMode = result.toString();
		
		//Shot mode
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Fast Imaging mode']/subparameter['shot mode']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI shot mode ->%s \n",result.toString());
		dwiShotMode= result.toString();
		
		//EPI Factor - EPI Factor
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='EPI factor']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI EPI factor ->%d\n",Integer.valueOf(result.toString()));
		dwiEPIFactor[0] = Integer.valueOf(result.toString());
		
		//EPI Factor - Navigator	- This needs to already be set.
		dwiEPIFactor[1]=navEPIFactor;
		System.out.format("DTI NAV factor ->%d\n", navEPIFactor);
		
		//Echoes
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Echoes']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI number of echoes ->%d\n",Integer.valueOf(result.toString()));
		dwiNumEchoes = Integer.valueOf(result.toString());
		
		//*********************************************************************************
		//**************************************GEOMETRY***********************************
		//*********************************************************************************
		
		//FOV FH
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='FOV          FH (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI FOV FH _->%d\n", Integer.valueOf(result.toString()));
		dwiFOV[0] = Integer.valueOf(result.toString());
		
		//FOV RL
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='FOV          FH (mm)']/subparameter[@name='RL (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI FOV RL _->%d\n", Integer.valueOf(result.toString()));
		dwiFOV[1] = Integer.valueOf(result.toString());
		
		//FOV AP
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='FOV          FH (mm)']/subparameter[@name='AP (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI FOV AP _->%d\n", Integer.valueOf(result.toString()));
		dwiFOV[2] = Integer.valueOf(result.toString());
		
		//SENSE Factor 
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='SENSE']/subparameter[@name='P reduction (RL)']/@value");
		Object resultRL = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI SENSE factor ->%d\n",Integer.valueOf(resultRL.toString()));
		dwiSenseFact = Integer.valueOf(resultRL.toString());
		
		
		//*********************************************************************************
		//**************************************INFOPAGE***********************************
		//*********************************************************************************
		
		//Acquisition Matrix M x P
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='InfoPage']/parameter[@name='ACQ matrix M x P']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		String res = result.toString();
		String[] r = res.split(" x ");
		dwiAcqMtrxMP[0] = Integer.valueOf(r[0]);
		dwiAcqMtrxMP[1] = Integer.valueOf(r[1]);
		System.out.format("DTI Acquisition Matrix M x P -> %d,%d\n",dwiAcqMtrxMP[0],dwiAcqMtrxMP[1]);
		r=null;
		res=null;
		
		//*********************************************************************************
		//***************************************MOTION************************************
		//*********************************************************************************
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='motion']/parameter[@name='NSA']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiNSA= Integer.valueOf(result.toString());
		System.out.format("DTI NSA ->%d\n",dwiNSA);
		
		//*********************************************************************************
		//*************************************OFFC/ANG************************************
		//*********************************************************************************
		
		//Off Center AP
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiOffCenter[2]= Float.valueOf(result.toString());
		System.out.format("DTI offcenter AP ->%f\n",dwiOffCenter[2]);
		
		//Off Center RL
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='RL (L=+mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiOffCenter[1] = Float.valueOf(result.toString());
		System.out.format("DTI offcenter RL ->%f\n",dwiOffCenter[1]);
		
		//Off Center FH
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='FH (H=+mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiOffCenter[0] = Float.valueOf(result.toString());
		System.out.format("DTI offcenter FH ->%f\n",dwiOffCenter[0]);
		
		//Angulation AP
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='Ang.  AP (deg)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiAngulation[2]= Float.valueOf(result.toString());
		System.out.format("DTI angulation AP ->%f\n",dwiAngulation[2]);
		
		//Angulation RL
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='offc/ang']/parameter[@name='Stack Offc. AP (P=+mm)']/subparameter[@name='RL (deg)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiAngulation[1] = Float.valueOf(result.toString());
		System.out.format("DTI angulation RL ->%f\n",dwiAngulation[1]);
		
		//Technique
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Scan mode']/subparameter[@name='technique']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiTechnique = result.toString();
		System.out.format("DTI technique ->%s\n",dwiTechnique);
		
		//Diffusion Mode
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Diffusion mode']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiDiffMode = result.toString();
		System.out.format("DTI diffusion Mode ->%s\n",dwiDiffMode);
		
		//Acq Vox FH
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Voxel size   FH (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiAcqVox[0] = Float.valueOf(result.toString());
		System.out.format("DTI acquired voxel FH ->%f\n",dwiAcqVox[0]);
		
		//Acq Vox RL
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Voxel size   FH (mm)']/subparameter[@name='RL (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiAcqVox[1] = Float.valueOf(result.toString());
		System.out.format("DTI acquired voxel RL ->%f\n",dwiAcqVox[1]);
		
		//Acq Vox FH
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Slice thickness (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiAcqVox[2] = Float.valueOf(result.toString());
		System.out.format("DTI acquired voxel FH ->%f\n",dwiAcqVox[2]);
		
		//BW echo 1
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='InfoPage']/parameter[@name='WFS (pix) / BW (Hz) [echo1]']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiBW[0] = Float.valueOf(result.toString().split(" / ")[1]);
		System.out.format("DTI BW echo 1 ->%f\n",dwiBW[0]);
		
		//BW echo 2
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='InfoPage']/parameter[@name='WFS (pix) / BW (Hz) [echo2]']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiBW[1] = Float.valueOf(result.toString().split(" / ")[1]);
		System.out.format("DTI BW echo 2 ->%f\n",dwiBW[1]);
		
		//Recon size
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Reconstruction matrix']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiReconRes = Integer.valueOf(result.toString());
		System.out.format("DTI recon size ->%d\n",dwiReconRes);
		
		//Number of slices
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='slices']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiNumSlices = Integer.valueOf(result.toString());
		System.out.format("DTI number of slices ->%d\n",dwiNumSlices);
		
		//Slice gap
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='gap (mm)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiSliceGap = Float.valueOf(result.toString());
		System.out.format("DTI slice gap ->%f\n",dwiSliceGap);
		
		//Slice orientation
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='slice orientation']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI Slice orientation ->%s\n", result.toString());
		dwiSliceOrientation = result.toString();
		
		//Fold over Direction
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='fold-over direction']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI Fold over direction ->%s\n", result.toString());
		dwiFoldOverDirection = result.toString();
		
		//Fat shift direction
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name='Stacks']/subparameter[@name='fat shift direction']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI fat shift direction ->%s\n", result.toString());
		dwiFatShiftDir=result.toString();
		
		//Directional resolution
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Diffusion mode']/subparameter[@name='directional resolution']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI directional resolution ->%s\n", result.toString());
		dwiDirectionalResolution=result.toString();
		
		//Halfscan
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Halfscan']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		if (result.toString()=="no"){
			dwiHalfscan = false;
		}else if(result.toString()=="yes"){
			dwiHalfscan = true;
		}
		System.out.format("DTI halfscan ->%s\n", result.toString());
	
		
		//Number of diffusion weightings
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Diffusion mode']/subparameter[@name='nr of b-factors']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI number of diffusion weightings ->%d\n", Integer.valueOf(result.toString()));
		dwiNumberOfBValues=Integer.valueOf(result.toString());
		
		//Number of diffusion weightings
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name='Diffusion mode']/subparameter[@name='gradient overplus']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		if (result.toString().equals("no")){
			dwiGradientOverplus = false;
		}else if (result.toString().equals("yes")){
			dwiGradientOverplus = true;
		}
		System.out.format("DTI gradient overplus ->%s\n", result.toString());
		
		//reduced acq time
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='InfoPage']/parameter[@name='Scan percentage (%)']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.format("DTI reduced acquisition time ->%s\n", result.toString());
		dwiAcqReducedAcqTime=Integer.valueOf(result.toString());
		
	}
	
	//*******Begin Reference getters
	public String getRefScanName(){return this.refScanName;}
	public int[] getRefFOV(){return this.refFOV;}
	public float[] getRefAcquiredVoxels(){return this.refAcquiredVoxels;}
	public float getRefSliceThickness(){return this.refSliceThickness;}
	public boolean getRefFoldOverSupression(){return this.refFoldOverSupression;}
	public String getRefSliceOrientation(){return this.refSliceOrientation;}
	public String getRefFoldOverDirection(){return this.refFoldOverDirection;}
	public String getRefFatShiftDir(){return this.refFatShiftDir;}
	public float[] getRefOffCenter(){return this.refOffCenter;}			//AP/RL/FH
	public float[] getRefAngulation(){return this.refAngulation;}			//AP/RL/FH
	public int getRefNumberOfSlices(){return this.refNumberOfSlices;}
	//*******End Reference getters
	
	//*******Begin Reference setters
	public void setRefScanName(String refScanName){
		this.refScanName = refScanName;
	}
	public void setRefFOV(int[] refFOV){
		this.refFOV = refFOV;
	}
	public void setRefAcquiredVoxels(float[] vox){
		this.refAcquiredVoxels=vox;
	}
	public void setRefSliceThickness(float thick){
		this.refSliceThickness=thick;
	}
	public void setRefFoldOverSupression(boolean supp){
		this.refFoldOverSupression=supp;
	}
	public void setRefSliceOrientation(String orient){
		this.refSliceOrientation=orient;
	}
	public void setRefFoldOverDirection(String dir){
		this.refFoldOverDirection=dir;
	}
	public void setRefFatShiftDir(String dir){
		this.refFatShiftDir=dir;
	}
	public void setRefOffCenter(float[] off){
		this.refOffCenter=off;
	}
	public void setRefAngulation(float[] ang){
		this.refAngulation=ang;
	}			
	public void  setRefNumberOfSlices(int num){
		this.refNumberOfSlices=num;
	}
	//*******End Reference setters
	
	
	public void setNavEPIFactor(int factor){
		this.navEPIFactor=factor;
	}

}
