package edu.vanderbilt.masi.algorithms.dti;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

import org.apache.commons.io.FilenameUtils;

public class MSHDTIUtil {
	private static final String cvsversion = "$Revision: 1.8 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "") .replace(" ", "");
	File batch;
	
	/*
	 * Write the batch file based on all of the input params
	 */
	public void initBatch(ParamCollection inputParams,File batchfile, File outputDir){
		 batch = new File(batchfile+File.separator+"s_batch.m");
		FileWriter fw;
		try {
			fw = new FileWriter(batch);
			
			//The header
			fw.write("%[s_batch] is the auto-generated JIST batch file for MATLAB."+"\n");
			fw.write("%This is version "+revnum+"\n");
			fw.write("clear all"+"\n");
			fw.write("close all"+"\n");
			fw.write("clc"+"\n");
			fw.write("warning off"+"\n");
			fw.write("format longg\n");
			fw.write("disp('-------------------- Set directories --------------------')"+"\n");
			fw.write("examcardFilename_s = '"+new File(inputParams.getFirstChildByLabel("examCard - the xml dumped examcard file (.xml)").toString()).getAbsolutePath()+"';\n");
			fw.write("anatomy_s = '"+inputParams.getFirstChildByLabel("anatomy_s - the type of anatomy that was scanned").toString()+"';\n");
			fw.write("savePathName_s='"+outputDir.getAbsolutePath()+"';\n");
			fw.write("sharedDir_s='"+outputDir.getAbsolutePath()+File.separator+"shared"+"';\n");
			fw.write("scriptDir_s = '"+inputParams.getFirstChildByLabel("scriptDir - the locaiton of all of the .m files").toString()+"';\n");
			
			//fw.write("loadDir_s = sprintf('%s%s%s%slistdata%s',projectDir_s,filesep,studyname_s,filesep,filesep);"+"\n");
			//fw.write("sharedDir_s = sprintf('%s%s%s%slistdata%sshared%s',projectDir_s,filesep,studyname_s,filesep,filesep,filesep);"+"\n");
			
			fw.write("% Move to script directory."+"\n");
			fw.write("add_term_at_data_dir=[];\n");
			fw.write("addpath(scriptDir_s)"+"\n");
			fw.write("fprintf('\\n\\n')"+"\n");

			
			//RUN PROCEDURES
			fw.write("raw_sequence_name='"+inputParams.getFirstChildByLabel("dtiScanName - the dti sequence variant name in the examcard")+"';\n");
			fw.write("ref_sequence_name='"+inputParams.getFirstChildByLabel("refScanName - the reference seqeuence variant name in the examcard")+"';\n");
			fw.write("disp('-------------------- Run procedures --------------------')"+"\n");
			fw.write("dom = xml_read(examcardFilename_s);"+"\n");
			fw.write("ind_raw_file = f_get_index_by_exam_name(dom,raw_sequence_name);"+"\n");
			fw.write("if isempty(ind_raw_file)"+"\n");
			fw.write("\tfprintf(2,'ERROR: could not find sequence %s in examcard. Can not continue',raw_sequence_name);"+"\n");
			fw.write("\terror('');"+"\n");
			fw.write("end\n");
			fw.write("DWIexamcardindex = ind_raw_file;\n"); 
			    
			fw.write("REFexamcardindex = f_get_index_by_exam_name(dom,ref_sequence_name)\n");
			fw.write("if isempty(ind_raw_file)\n");
			fw.write("\tfprintf(2,'ERROR: could not find sequence %s in examcard. Can not continue',ref_sequence_name);\n");
			fw.write("\terror('');\n");
			fw.write("end\n");
			
			fw.write("%-------------------- Batch process --------------------\n");
			fw.write("BATCHparams.read_data = "+new File(inputParams.getFirstChildByLabel("readData - should the data be read?").toString()).getName()+";\n");
			fw.write("BATCHparams.recon_data = "+inputParams.getFirstChildByLabel("reconData - should the data be reconstructed").toString()+";\n");
			//Handle the non required SSH data.
			if (inputParams.getFirstChildByLabel("dtiSSHPAR - the header file for the single shot scan").toString().equals("None")){
				fw.write("SSHrecfilename = {};"+"\n");
				fw.write("SSHparfilename = {};"+"\n");
			}else{
				fw.write("SSHrecfilename ={'"+new File(inputParams.getFirstChildByLabel("dtiSSHPAR - the header file for the single shot scan").toString()).getAbsolutePath()+"'};"+"\n");
				fw.write("SSHparfilename ={'"+new File(inputParams.getFirstChildByLabel("dtiSSHREC - the rec file for the single shot scan").toString()).getAbsolutePath()+"'};"+"\n");

			}
			//Handle the non required field man data
			if (inputParams.getFirstChildByLabel("refSSHPAR - the header file for the single shot ref scan").toString().equals("None")){
				fw.write("FMAPrecfilename = [];"+"\n");
				fw.write("FMAPparfilename = [];"+"\n");
			}else{
				fw.write("FMAPrecfilename =['"+new File(inputParams.getFirstChildByLabel("refSSHREC - the rec file for the single shot ref scan").toString()).getAbsolutePath()+"'];"+"\n");
				fw.write("FMAPparfilename =['"+new File(inputParams.getFirstChildByLabel("refSSHPAR - the header file for the single shot ref scan").toString()).getAbsolutePath()+"'];"+"\n");

			}
			String[] temp = inputParams.getFirstChildByLabel("dtiRaw - the raw DTI data (.data)").toString().split(File.separator);
			
			fw.write("REFrawdatafilename = '"+new File(inputParams.getFirstChildByLabel("refRaw - the raw Reference data (.data)").toString()).getAbsolutePath()+"';\n");
			fw.write("REFrawlistfilename = '"+new File(inputParams.getFirstChildByLabel("refList - the raw Reference data header (.list)").toString()).getAbsolutePath()+"';\n");
			fw.write("DWIrawdatafilename = '"+new File(inputParams.getFirstChildByLabel("dtiRaw - the raw DTI data (.data)").toString()).getAbsolutePath()+"';\n");
			fw.write("DWIrawlistfilename = '"+new File(inputParams.getFirstChildByLabel("dtiList - the raw DTI data header (.list)").toString()).getAbsolutePath()+"';\n");
			
			fw.write("\n");
			
			fw.write("%-------------------- Scanner parameter --------------------\n");
			String tmp = inputParams.getFirstChildByLabel("fieldStrength - main field strength in gauss").toString();
			if (tmp.equals("3 Tesla")){
				fw.write("main_field_strength = 30000;\n"); 
			}else if (tmp.equals("7 Tesla")){
				fw.write("main_field_strength = 70000;\n"); 
			}
			fw.write("EX_GEO_cur_stack_coil_id = '"+inputParams.getFirstChildByLabel("coilSelection - the type of coil used").toString()+"';\n");
			fw.write("coilType = EX_GEO_cur_stack_coil_id;\n");
			fw.write("\n");
			
			
			fw.write("%-------------------- Patient geometry --------------------\n");
			fw.write("patient_orientation = '"+inputParams.getFirstChildByLabel("patientGeometry - the geometry of the patient").toString()+"';\n");
			fw.write("patient_position = '"+inputParams.getFirstChildByLabel("patientPosition - the poisition of the patient").toString()+"';\n");
			fw.write("\n");
			
			fw.write("%-------------------- Data processing --------------------\n");
			fw.write("user_defined_dw_ori = [];\n");
			//fw.write("user_defined_dw_ori = user_defined_dw_ori(:,[2,3,1]);\n");
			fw.write("NAV_EPI_FACTOR = "+inputParams.getFirstChildByLabel("navEPIFactor - the navigator scan EPI factor").toString()+";\n");
			fw.write("\n");
			
			fw.write("%===== SMAPparams =====\n");
			fw.write("smap_fit_method_c = {'l2p','tps'};\n");
			fw.write("smap_fit_method = '"+inputParams.getFirstChildByLabel("sensitivityFit - method for fitting the sensitivity map").toString()+"';\n");
			fw.write("smap_gen_bodycoil = '"+inputParams.getFirstChildByLabel("sensitivityCoil - coild type used").toString()+"';\n");
			fw.write("\n");		
			
			fw.write("%===== DATAFLAGparams =====\n");
			
			fw.write("epiRefType = '"+inputParams.getFirstChildByLabel("refEPIType - the type of reference epi scan").toString()+"';\n");
			tmp = inputParams.getFirstChildByLabel("runEPICorrection - run epi correction").toString();
			if (tmp.equals("true")){
				fw.write("epi_corr_sel_total_var=1;\n");
			}else if (tmp.equals("false")){
				fw.write("epi_corr_sel_total_var=0;\n");
			}else{
				//TODO
			}
			String coilType = inputParams.getFirstChildByLabel("coilSelection - the type of coil used").toString();
			if (coilType.equals("SENSE-Breast-4") || coilType.equals("RX-Intf-1_Quad-TR-1") || coilType.equals("SENSE-Head-32")){
				fw.write("epi_corr_fit_method = 4;\n");
			}else if (coilType.equals("RX-Intf-1") || coilType.equals("SENSE-Head-7T") || coilType.equals("SENSE-Head-8") || coilType.equals("SENSE-NV-16")){
				fw.write("epi_corr_fit_method = 1;\n");
			}else{
				fw.close();
				throw new RuntimeException("Unexpected coil type "+coilType);
			}
			
			tmp = inputParams.getFirstChildByLabel("matchSMAPposition - do you want to amtch the smap and the image position").toString();
			if (tmp.equals("true")){
				fw.write("match_obj_pos_smap_img=1;\n");
			}else if (tmp.equals("false")){
				fw.write("match_obj_pos_smap_img=0;\n");
			}else{
				//TODO
			}
			
			//This could be potentially stupid
			tmp = inputParams.getFirstChildByLabel("detlaManual - manual offset correction factor").toString();
			System.out.println(tmp);
			if (tmp.equals("0")){
				fw.write("delta_manual=[];\n");
			}else{
				fw.write("delta_manual="+tmp+";\n");
			}
			
			fw.write("calc_ssh_diff = "+inputParams.getFirstChildByLabel("calcSSHDiff - calculate the diffusion for the single shot data?").toString()+";\n");


			fw.write("read_ref = "+inputParams.getFirstChildByLabel("readREF - should the ref data be read").toString()+";\n");
			fw.write("read_dwi = "+inputParams.getFirstChildByLabel("readDWI - should the dwi data be read").toString()+";\n");
			fw.write("gen_fmap = "+inputParams.getFirstChildByLabel("genFMAP - should the fmap be generated").toString()+";\n");
			fw.write("gen_smap = "+inputParams.getFirstChildByLabel("genSMAP - should the smap be generated").toString()+";\n");

			
			fw.write("coreg_nav_to_img = false;\n");
			
			fw.write("phase_corr = "+inputParams.getFirstChildByLabel("phaseCorrection - run phase nav phase correction").toString()+";\n");    
			fw.write("nav_fmap_corr = "+inputParams.getFirstChildByLabel("navFmapCorrection - use fieldmap correction on nav and recon img").toString()+";\n");
			fw.write("if isempty(FMAPrecfilename) || isempty(FMAPparfilename)\n");
			fw.write("\tnav_fmap_corr = false;\n");
			fw.write("end\n");
			fw.write("nav_deform = "+inputParams.getFirstChildByLabel("navDeform - use deformation of navigator on img").toString()+";\n");
			fw.write("psi_method = "+inputParams.getFirstChildByLabel("psiMethod - the method to use for noise correlation").toString()+";\n");
			fw.write("calc_diff = "+inputParams.getFirstChildByLabel("calfDiff - calculate FA and MD etc").toString()+";\n");
			fw.write("precalc_encoding_matrix_flag = "+inputParams.getFirstChildByLabel("precalcEncodingMTX - precalculate the encoding matrix").toString()+";\n");
			fw.write("sub_encoding_matrix_flag = "+inputParams.getFirstChildByLabel("useSubEncMtx - use the subencoding matrix").toString()+";\n");
			fw.write("sub_encoding_matrix_siz_idx = "+inputParams.getFirstChildByLabel("subEncMtxSz - the size of the subencoding matrix").toString()+";\n");
			fw.write("if precalc_encoding_matrix_flag==true\n");
			fw.write("\tsub_encoding_matrix_flag = false;\n");
			fw.write("\tsub_encoding_matrix_siz_idx = 0;\n");
			fw.write("end\n");
			fw.write("run_pct = "+inputParams.getFirstChildByLabel("pct - use parallel computing toolbox in matlab")+";\n");
			
			tmp = inputParams.getFirstChildByLabel("resizeDTI - resize the DTI data").toString();
			if (tmp.equals("true")){
				fw.write("flag_resize_DWI = 1;\n");
			}else if (tmp.equals("false")){
				fw.write("flag_resize_DWI = 0;\n");
			}
			
			tmp = inputParams.getFirstChildByLabel("resizeDTIFactor - the scaling factor to resize the DTI data").toString();
			if (tmp.equals("0")){
				fw.write("flag_average_idx = [];\n");
			}else{
				fw.write("flag_average_idx = "+tmp+";\n");
			}
			
			fw.write("optim_s = '"+inputParams.getFirstChildByLabel("optim - the optimizer for registration").toString()+"';\n");
			fw.write("method_s = '"+inputParams.getFirstChildByLabel("method - the method of registration").toString()+"';\n");
			fw.write("cost_s = '"+inputParams.getFirstChildByLabel("cost - the registration cost function").toString()+"';\n");
			tmp=inputParams.getFirstChildByLabel("medFilt - run median filtering on tensor calculation").toString();
			if (tmp.equals("false")){
				fw.write("medfilt_s = 'off';\n");
			}else if (tmp.equals("true")){
				fw.write("medfilt_s = 'on';\n");
			}
			fw.write("medfilt_kern_siz = "+inputParams.getFirstChildByLabel("filtSize - the size of the neighboring filter [n x n]").toString()+";\n"); 
			fw.write("zoom_s = "+inputParams.getFirstChildByLabel("zoom - was zoom mode used in acquisition").toString()+";\n"); 

			
			fw.write("\n");
			
			fw.write("%-------------------- Main procedures --------------------\n");
			fw.write("% Run process.\n");
			fw.write("t0_batch = clock;\n");
			fw.write("s_recon_main\n");

			fw.write("t1_batch = etime(clock,t0_batch);\n");
			fw.write("fprintf('BATCH PROCESS FINISHED in %f min\\n',t1_batch/60)\n");

			    
			fw.write("% clear all\n");
			fw.write("warning on\n");
			fw.write("pack\n");

			fw.write("c = clock;\n");
			fw.write("disp([num2str(c(4)) ':' num2str(c(5))])\n");
			fw.write("exit\n");

			fw.write("%% END\n");
			fw.write("\n");
			//Finally, close the writer
			fw.close();
			
		} catch (IOException e) {
			JistLogger.logError(JistLogger.SEVERE, "ERROR: Could not write batch file");
			e.printStackTrace();
		}
		


	}

	public File getBatch() {
		// TODO Auto-generated method stub
		return this.batch;
	}
	
	
}
