package edu.vanderbilt.masi.algorithms.dti;

import java.io.File;

public class REFParams {
	private File listFile;
	private File dataFile;
	private int[] FOV;		//FH, RL, AP
	private int[] acq_vox;	//FH, RL, AP
	private int slice_thickness;
	private boolean fold_over_suppression;
	private int slices;
	private String slice_orientation;
	private String fold_over_dir;
	private String fat_shift_dir;
	private float[] Offc;	//FH, RL, AP
	private float[] Ang;    //FH, RL, AP
	private int ovs_fac_m;
	private int ovs_fac_p;
	private int nCOIL;
	private int bodycoil_idx;
	
	public REFParams(File listFile,File dataFile,int[] FOV,int[] acq_vox,int slice_thickness,
			boolean fold_over_suppression,int slices,String slice_orientation,
			String fold_over_dir,String fat_shift_dir,float[] Offc,float[] Ang,
			int ovs_fac_m,int ovs_fac_p,int nCOIL,int bodycoil_idx){
		
		this.listFile=listFile;
		this.dataFile=dataFile;
		this.FOV=FOV;
		this.acq_vox=acq_vox;
		this.slice_thickness=slice_thickness;
		this.fold_over_suppression=fold_over_suppression;
		this.slices = slices;
		this.slice_orientation = slice_orientation;
		this.fold_over_dir=fold_over_dir;
		this.fat_shift_dir=fat_shift_dir;
		this.Offc=Offc;
		this.Ang=Ang;
		this.ovs_fac_m = ovs_fac_m;
		this.ovs_fac_p = ovs_fac_p;
		this.nCOIL = nCOIL;
		this.bodycoil_idx=bodycoil_idx;
		
		
	}
	public File get_listFile(){
		return this.listFile;
	}
	public File get_dataFile(){
		return this.dataFile;
	}
	public int[] get_FOV(){
		return this.FOV;
	}
	public int[] get_acq_vox(){
		return this.acq_vox;
	}
	public int get_slice_thickness(){
		return this.slice_thickness;
	}
	public boolean get_fold_over_suppression(){
		return this.fold_over_suppression;
	}
	public int get_slices(){
		return this.slices;
	}
	public String get_slice_orientation(){
		return this.slice_orientation;
	}
	public String get_fold_over_dir(){
		return this.fold_over_dir;
	}
	public String get_fat_shift_dir(){
		return this.fat_shift_dir;
	}
	public float[] get_Offc(){
		return this.Offc;
	}
	public float[] get_Ang(){
		return this.Ang;
	}
	public int get_ovs_fac_m(){
		return this.ovs_fac_m;
	}
	public int get_ovs_fac_p(){
		return this.ovs_fac_p;
	}
	public int get_nCOIL(){
		return this.nCOIL;
	}
	public int get_bodycoil_idx(){
		return this.bodycoil_idx;
	}
	
}
