package edu.vanderbilt.masi.algorithms.labelfusion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class HierarchyMapper {
	
	private HashMap<Integer,Integer>[] labelMap; 
	private boolean initialized = false;
	
	
	//Single Hierarchy
	@SuppressWarnings("unchecked")
	public HierarchyMapper(File f,int n){
		
		labelMap = new HashMap[1];
		
		if(n < 1){
			JistLogger.logError(JistLogger.SEVERE, "Error, hierarchy level must be at least 1");
		}
		
		readHierarchyFile(f, n, 0);
		
	}
	
	//Multiple Hierarchies
	@SuppressWarnings("unchecked")
	public HierarchyMapper(List<File> files, File map){
		String line;
		labelMap = new HashMap[files.size()];
		try {
			BufferedReader br = new BufferedReader(new FileReader(map));
			int n;
			File f;
			for(int i=0;i<files.size();i++){
				line = br.readLine();
				n=Integer.parseInt(line);
				f = files.get(i);
				readHierarchyFile(f,n,i);
			}
			br.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	
	public boolean isInitialized(){ return this.initialized ; }
	
	private void readHierarchyFile(File f,int n, int ind){
		JistLogger.logOutput(JistLogger.WARNING, "Loading file "+f.getAbsolutePath()+ " as hierarchy "+ind);
		try {
			BufferedReader br = new BufferedReader(new FileReader(f));
			String line;
			line = br.readLine();
			String[] bits = line.split(",");
			if(bits.length < n){
				JistLogger.logError(JistLogger.SEVERE, String.format("Error, there are only %d levels in the hierarchy and level %d was requested",bits.length,n));
				br.close();
				return;
			}
			labelMap[ind] = new HashMap<Integer,Integer>(600);
			while((line = br.readLine())!=null){
				bits = line.split(",");
				int s = Integer.parseInt(bits[0]);
				int e = Integer.parseInt(bits[n]);
				labelMap[ind].put(s, e);
			}
			br.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		initialized = true;
	}
	
	public ImageData map(ImageData im){
		return this.map(im,0);
	}
	
	public ImageData map(ImageData im, int ind){
		
		int r = im.getRows();
		int c = im.getCols();
		int s = im.getSlices();
		int m = im.getComponents();
		
		int nl;
		JistLogger.logOutput(JistLogger.WARNING, r+" "+c+" "+s+" "+m+" ");
		JistLogger.logOutput(JistLogger.WARNING, "Ind: "+ind);
		for (int i=0;i<r;i++)
			for(int j=0;j<c;j++)
				for(int k=0;k<s;k++)
					for(int l=0;l<m;l++){
						int lab = im.getInt(i,j,k,l);
						if(!labelMap[ind].containsKey(lab)){
							JistLogger.logOutput(JistLogger.WARNING, "Error label "+lab+" found but does not have a corresponding label in the hierarchy");
							nl = 0;
						}else
							nl = labelMap[ind].get(im.getInt(i,j,k,l));
						im.set(i, j, k, l,nl);
					}
		return im;
	}

}
