package edu.vanderbilt.masi.algorithms.labelfusion;

import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;

public class ObservationVolume2 extends ObservationBase2 {
	
	protected short [][][][][] obs;
	private short [] tmplabels = new short [1];
	private float [] tmpvals = new float [1];
	
	public ObservationVolume2 (ParamVolumeCollection obsvols,
							  float cons_thresh_in) {
		this(obsvols, cons_thresh_in, new int [4], new int [4], false);
	}
	
	public ObservationVolume2(ParamVolumeCollection obsvols,
							 float cons_thresh_in,
							 int [] sv_in,
							 int [] pv_in,
							 boolean quiet) {
		super(cons_thresh_in, sv_in, pv_in);
		setLabel("ObservationVolume");

		JistLogger.logOutput(JistLogger.INFO,"\n+++ Initializing Label Observations (Volume Type)  +++");

		// initialize the observation volumes
		determine_cropping_information(obsvols);
		obs = load_label_images(obsvols);

		if (!quiet) {
			consensus = new boolean[dims[0]][dims[1]][dims[2]][dims[3]];
			cons_estimate = new short[dims[0]][dims[1]][dims[2]][dims[3]];
			for (int x = 0; x < dims[0]; x++)
				for (int y = 0; y < dims[1]; y++)
					for (int z = 0; z < dims[2]; z++)
						for (int v = 0; v < dims[3]; v++) {
							consensus[x][y][z][v] = false;
							cons_estimate[x][y][z][v] = -1;
						}
			update_consensus();

			// print out some information
			JistLogger.logOutput(JistLogger.INFO, "-> Determined the following information");
			JistLogger.logOutput(JistLogger.INFO, "Number of Raters: " + num_raters);
			JistLogger.logOutput(JistLogger.INFO, "Number of Labels: " + num_labels);
			JistLogger.logOutput(JistLogger.INFO, String.format("Original Dimensions (voxels): [%d %d %d %d]", orig_dims[0], orig_dims[1], orig_dims[2], orig_dims[3]));
			JistLogger.logOutput(JistLogger.INFO, String.format("Cropped Dimensions (voxels): [%d %d %d %d]", dims[0], dims[1], dims[2], dims[3]));
			JistLogger.logOutput(JistLogger.INFO, "Ignore Consensus: " + ignore_consensus());
		}
	}
	
	public short get(int x, int y, int z, int v, int j) { return(obs[x][y][z][v][j]); }
	public float get_val(int x, int y, int z, int v, int j) { return(1); }
	public short [] get_all(int x, int y, int z, int v, int j) {
		tmplabels[0] = obs[x][y][z][v][j];
		return(tmplabels);
	}
	public float [] get_all_vals(int x, int y, int z, int v, int j) {
		tmpvals[0] = 1;
		return(tmpvals);
	}
	public void free_obs(int x, int y, int z, int v) { obs[x][y][z][v] = null; }
}
