package edu.vanderbilt.masi.algorithms.regression;

import org.w3c.dom.*;

public class FeatureResponse {
	private Point refercePoint;
	private Box box;
	
	private int xDim;
	private int yDim;
	private int zDim;
	
	public static FeatureResponse CreateFeature(int x, int y, int z)
	{
		return new FeatureResponse(x, y, z);
	}
	
	public FeatureResponse() {
		// TODO Auto-generated constructor stub
		refercePoint = null;
		box = null;
	}
	
	public FeatureResponse(int xDim, int yDim, int zDim)
	{
		this.xDim = xDim;
		this.yDim = yDim;
		this.zDim = zDim;
		
		int x = (int)(Math.random() * xDim);
		int y = (int)(Math.random() * yDim);
		int z = (int)(Math.random() * zDim);
		this.refercePoint = new Point(x, y, z);
		
		x = (int)(Math.random() * xDim);
		y = (int)(Math.random() * yDim);
		z = (int)(Math.random() * zDim);
		Point boxCenter = new Point(x, y, z);
		int xlen = (int)(Math.random() * xDim / 8) + xDim / 8;
		int ylen = (int)(Math.random() * yDim / 8) + yDim / 8;
		int zlen = (int)(Math.random() * zDim / 8) + zDim / 8;
		this.box = new Box(boxCenter, xlen, ylen, zlen);
	}

	public float GetResponse(DataCollection dc, int index)
	{
		int x = dc.GetX(index);
		int y = dc.GetY(index);
		int z = dc.GetZ(index);
		
		x -= this.refercePoint.GetX();
		y -= this.refercePoint.GetY();
		z -= this.refercePoint.GetZ();
		
		int left = box.GetLeft() + x;
		if (left < 0) left = 0;
		int right = box.GetRight() + x;
		if (right == xDim) right = xDim - 1;
		int top = box.GetTop() + y;
		if (top < 0) top = 0;
		int buttom = box.GetButtom() + y;
		if (buttom == yDim) buttom = yDim - 1;
		int front = box.GetFront() + z;
		if (front < 0) front = 0;
		int back =  box.GetBack() + z;
		if (back == zDim) back = zDim - 1;
		
		float sum = 0;
		int volum = 0;
		for (int i = left; i < right + 1 && i < xDim; ++i)	
			for (int j = top; j < buttom + 1 && j < yDim; ++j)
				for (int k = front; k < back && k < zDim; ++k)
				{
					int l = i + j * xDim + k * xDim * yDim;
					sum += dc.GetDataPoint(l);
					++volum;
				}

		if (volum == 0) ++volum;
		return sum / volum;
	}
	
	public void createFeatureElement(Document doc, Element featureElement) {
		featureElement.setAttribute("xDim", Integer.toString(xDim));
		featureElement.setAttribute("yDim", Integer.toString(yDim));
		featureElement.setAttribute("zDim", Integer.toString(zDim));
		
		Element pointElement = doc.createElement("ReferancePoint");
		if (refercePoint == null) {
			pointElement.setAttribute("isNull", "null");
		}
		else {
			pointElement.setAttribute("x", Integer.toString(refercePoint.GetX()));
			pointElement.setAttribute("y", Integer.toString(refercePoint.GetY()));
			pointElement.setAttribute("z", Integer.toString(refercePoint.GetZ()));
		}
		featureElement.appendChild(pointElement);
		
		Element boxElement = doc.createElement("Box");
		if (box == null) {
			boxElement.setAttribute("isNull", "null");
		}
		else {
			boxElement.setAttribute("left", Integer.toString(box.GetLeft()));
			boxElement.setAttribute("right", Integer.toString(box.GetRight()));
			boxElement.setAttribute("top", Integer.toString(box.GetTop()));
			boxElement.setAttribute("buttom", Integer.toString(box.GetButtom()));
			boxElement.setAttribute("front", Integer.toString(box.GetFront()));
			boxElement.setAttribute("back", Integer.toString(box.GetBack()));
		}
		featureElement.appendChild(boxElement);
	}
	
	public void XmlParse(Element featureElement) {
		xDim = Integer.parseInt(featureElement.getAttribute("xDim"));
		yDim = Integer.parseInt(featureElement.getAttribute("yDim"));
		zDim = Integer.parseInt(featureElement.getAttribute("zDim"));
		
		Element pointElement = 
				(Element) featureElement.getElementsByTagName("ReferancePoint").item(0);
		if (pointElement.hasAttribute("isNull")) {
			refercePoint = null;
		}
		else {
			int x = Integer.parseInt(pointElement.getAttribute("x"));
			int y = Integer.parseInt(pointElement.getAttribute("y"));
			int z = Integer.parseInt(pointElement.getAttribute("z"));
			refercePoint = new Point(x, y, z);
		}
		
		Element boxElement = 
				(Element) featureElement.getElementsByTagName("Box").item(0);
		if (boxElement.hasAttribute("isNull")) {
			box = null;
		}
		else {
			int left = Integer.parseInt(boxElement.getAttribute("left"));
			int right = Integer.parseInt(boxElement.getAttribute("right"));
			int top = Integer.parseInt(boxElement.getAttribute("top"));
			int buttom = Integer.parseInt(boxElement.getAttribute("buttom"));
			int front = Integer.parseInt(boxElement.getAttribute("front"));
			int back = Integer.parseInt(boxElement.getAttribute("back"));
			box = new Box(left, right, top, buttom, front, back);
		}
	}
}
