package edu.vanderbilt.masi.algorithms.regression;

public class TrainingContext {
private int boxCount;
	
	public TrainingContext (int c) {
		boxCount = c;
	}
	public FeatureResponse GetRandomFeature(int x, int y, int z) {
      return new FeatureResponse(x, y, z); 
    }

    public StatisticsAggregator GetStatisticsAggregator() {
      return new StatisticsAggregator(boxCount);
    }

    public double ComputeInformationGain(
    		StatisticsAggregator allStatistics,
    		StatisticsAggregator leftStatistics,
    		StatisticsAggregator rightStatistics) {
    	double entropyBefore = ((StatisticsAggregator)(allStatistics)).Entropy();

    	StatisticsAggregator leftLineFitStats = (StatisticsAggregator)(leftStatistics);
    	StatisticsAggregator rightLineFitStatistics = (StatisticsAggregator)(rightStatistics);

    	int nTotalSamples = leftLineFitStats.GetSampleCount() + rightLineFitStatistics.GetSampleCount();

    	double entropyAfter = (
    		  leftLineFitStats.GetSampleCount() * leftLineFitStats.Entropy() + 
    		  rightLineFitStatistics.GetSampleCount() * rightLineFitStatistics.Entropy()
    		  ) / nTotalSamples;

    	return entropyBefore - entropyAfter;
    }

    public Boolean ShouldTerminate(double gain) {
    	return gain < 0.05;
    }
}
