package edu.vanderbilt.masi.plugins.classification;

import java.io.File;
import java.io.FileNotFoundException;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import edu.vanderbilt.masi.algorithms.clasisfication.ClassificationRunner;
import edu.vanderbilt.masi.plugins.classification.FeatureCalculatorPlugin.ExecuteWrapper;

public class ClassifierPlugin extends ProcessingAlgorithm {
	// Input Parameters
	public ParamFile input_classifier;
	public ParamFileCollection features;
	public ParamBoolean multithreading;

	// Output Parameters
	public ParamFileCollection output_classifier;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.5 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Builds Classifiers";
	private static final String longDescription = "";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);

		inputParams.setPackage("MASI");
		inputParams.setCategory("Classification");
		inputParams.setLabel("Build Classifier");
		inputParams.setName("Build_Classifier");

		inputParams.add(input_classifier = new ParamFile("Input Classifier"));
		input_classifier.setMandatory(true);
		input_classifier.setLoadAndSaveOnValidate(false);


		inputParams.add(features = new ParamFileCollection("Input Features"));
		features.setMandatory(true);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(output_classifier = new ParamFileCollection("Trained Classifier"));
	}

	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		try {
			ExecuteWrapper wrapper=new ExecuteWrapper();
			monitor.observe(wrapper);
			wrapper.execute(this);

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	protected class ExecuteWrapper extends AbstractCalculation {
		public void execute(ProcessingAlgorithm alg) throws FileNotFoundException{
			

			File outdir = new File(
					alg.getOutputDirectory() +
					File.separator +
					FileUtil.forceSafeFilename(alg.getAlgorithmName()) +
					File.separator);
			outdir.mkdirs();
			
			ClassificationRunner CR = new ClassificationRunner(input_classifier.getValue(),features.getValue(),outdir);
			output_classifier.setValue(CR.getFiles());
		}
	}
}

