package edu.vanderbilt.masi.plugins.dti;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;


import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.algorithms.dti.MSHDTIUtil;


public class PluginMultiShotDTIMatlab extends ProcessingAlgorithm{
	private static final String cvsversion = "$Revision: 1.10 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "") .replace(" ", "");
		
	//Top Level Batch Params
	ParamBoolean readData;			//Should the data be read in
	ParamBoolean reconData;			//Should reconstruction be performed
	
	//Required Data params
	ParamFile dtiRaw;				//The raw Fourier data for the DTI scan 
	ParamFile dtiList;				//The header for the DTI scan
	ParamFile refRaw;				//The raw Fourier data for the Reference scan
	ParamFile refList;				//The header for the Reference scan
	ParamString scriptDir; 			//Where all the m files are
	
	//Single Shot data
	ParamFile dtiSSHPAR;			//The associated single shot par file
	ParamFile dtiSSHREC;			//The associated single shot rec file
	ParamFile refSSHPAR;			//The associated single shot reference scan par file
	ParamFile refSSHREC;			//The associated single shot reference scan ref file
	ParamBoolean calcSSHDiff;		//process the single shot data?
	
	//Optional data params
	
	//Examcard parms
	ParamString dtiScanName;		//The name of the DTI sequence as seen in the examcard
	ParamString refScanName;		//The name of the reference sequence as seen in the examcard
	ParamFile examCard;				//The XML dumped xml examcard file
	
	//Scanner params
	ParamOption fieldStrength;		//B0 field strength (7T or 3T)
	ParamOption coilSelection;		//The coil type under 'Coil Selection' in the GEOMETRY tab
	ParamBoolean epiCorrection;		//run epi correction
	ParamInteger deltaManual; 		//manual fft correction fudge factor
	ParamBoolean matchSMAPposition; //match the SMAP and data positions
	
	//Patient Geometry
	ParamOption patientGeometry;	//supine, prone, rightdecubitus, leftdecubitus
	ParamOption patientPosition;	//headfirst or feet first
	ParamOption anatomyType;

	//SMAP Params
	ParamOption coilSensitivityFit;	//method for computing the coil sensitivity map
	ParamOption coilGeneralCoil;	//general coil (body or reference)
	ParamInteger fitOrder;
	ParamInteger fitSizeOut;
	ParamInteger fitSizeIn;
	ParamInteger voxDilate;
	ParamInteger voxErode;
	
	//DATAFLAGParams
	ParamOption refEPIType;			//the type of epi reference
	ParamOption epiCorrFitMethod;

	
	
	
	
	//Reconstruction Params
	ParamBoolean phaseCorrection;	//dwi reconstruction using navigator phase corerction
	ParamBoolean navFmapCorrection;	//use fieldmap correction on navigator recon image
	ParamBoolean navDeform; 		//use deformation of navigator to image
	ParamInteger navEPIFactor;		//the navigator scan EPI factor
	ParamInteger psiMethod;			//noise correlation method
	ParamBoolean calcDiff;			//calculate diffusion properities (FA,MD etc)
	ParamBoolean precalcEncodingMTX;//precalculate the encoding matrix
	ParamBoolean useSubEncodingMTX; //use the subencoding matrix
	ParamInteger subEncodingMTXSz;  //size of the subencoding matrix
	ParamBoolean resizeDTI;			//should the data be resized
	ParamInteger resizeDTIFactor;	//scale factor for resizing
	ParamBoolean readREF;
	ParamBoolean readDWI;
	ParamBoolean genSMAP;
	ParamBoolean genFMAP;
	
	
	//Coregistration
	ParamOption optim;				//the registration optimization function
	ParamOption method;				//the registration method (rigid or affine)
	ParamOption cost;				//the registration cost function
	
	//Tensor
	ParamBoolean medFilt;			//run median filtering on tensor
	ParamInteger filtSize;			//the size of the filter nxn
	
	//ZOOM
	ParamBoolean zoom;				//Is zoom imaging enabled?
	
	//Parallel Computing
	ParamBoolean pct;				//enable matlab parallel computing toolbox
	
	//Outputs
	ParamFile matlabSTDERR;
	ParamFile matlabSTDOUT;
	ParamFile matlabBatch;
	
	
	//Output contrasts 
	ParamFile fa3D;
	ParamFile fa4D;
	ParamFile eigval;
	ParamFile eigvec;
	ParamFile md;
	ParamFile residuals;
	ParamFile regfa3D;
	ParamFile regfa4D;
	ParamFile regeigval;
	ParamFile regeigvec;
	ParamFile regmd;
	ParamFile regresiduals;
	
	
	ParamFile I_fmap;
	ParamFile I_smap;
	ParamFile dwDataori01;	//Set the first file since these are spit out/slice
	
	ParamFile reconNavWinFmap;
	ParamFile reconNavWinOri;
	ParamFile reconImgCorrFmap;
	ParamFile p1;
	ParamFile iAliasSense01; //Set the first file since these are spit out/slice/orientation
	
	
	
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		// TODO Auto-generated method stub
				inputParams.setName("Multishot DTI Reconstruction - MATLAB");
				inputParams.setLabel("Multishot DTI Reconstruction - MATLAB");
				inputParams.setPackage("MASI");
				inputParams.setCategory("DTI");

				AlgorithmInformation info = getAlgorithmInformation();
				info.setWebsite("http://masi.vuse.vanderbilt.edu");
				info.add(new AlgorithmAuthor("Steve Damon", "stephen.m.damon@vanderbilt.edu", "http://masi.vuse.vanderbilt.edu"));
				info.setVersion(revnum);
				info.setEditable(false);
				info.setStatus(DevelopmentStatus.BETA);
				
				
				//Batch params - top level information
				ParamCollection batchParams = new ParamCollection("Batch Params");
				batchParams.add(readData = new ParamBoolean("readData - should the data be read?",true));
				readData.setMandatory(true);
				batchParams.add(reconData = new ParamBoolean("reconData - should the data be reconstructed",true));
				reconData.setMandatory(true);
				inputParams.add(batchParams);
				
				//Baseparams - Only data files
				ParamCollection dataParams = new ParamCollection("Data");
				dataParams.add(dtiRaw = new ParamFile("dtiRaw - the raw DTI data (.data)"));
				dtiRaw.setMandatory(true);
				dataParams.add(dtiList = new ParamFile("dtiList - the raw DTI data header (.list)"));
				dtiList.setMandatory(true);
				dataParams.add(refRaw = new ParamFile("refRaw - the raw Reference data (.data)"));
				refRaw.setMandatory(true);
				dataParams.add(refList = new ParamFile("refList - the raw Reference data header (.list)"));
				refList.setMandatory(true);

				dataParams.add(scriptDir = new ParamString("scriptDir - the locaiton of all of the .m files"));
				scriptDir.setMandatory(true);
				inputParams.add(dataParams);
				
				//Single shot params
				ParamCollection sshParams = new ParamCollection("Single Shot Data");
				sshParams.add(dtiSSHPAR = new ParamFile("dtiSSHPAR - the header file for the single shot scan"));
				dtiSSHPAR.setMandatory(false);
				sshParams.add(dtiSSHREC = new ParamFile("dtiSSHREC - the rec file for the single shot scan"));
				dtiSSHREC.setMandatory(false);
				sshParams.add(refSSHPAR = new ParamFile("refSSHPAR - the header file for the single shot ref scan"));
				refSSHPAR.setMandatory(false);
				sshParams.add(refSSHREC = new ParamFile("refSSHREC - the rec file for the single shot ref scan"));
				refSSHREC.setMandatory(false);
				sshParams.add(calcSSHDiff = new ParamBoolean("calcSSHDiff - calculate the diffusion for the single shot data?",false));
				calcSSHDiff.setMandatory(false);
				inputParams.add(sshParams);
				
				//Examcard params
				ParamCollection examParams = new ParamCollection("Examcard");
				examParams.add(examCard = new ParamFile("examCard - the xml dumped examcard file (.xml)"));
				examCard.setMandatory(true);
				examParams.add(dtiScanName = new ParamString("dtiScanName - the dti sequence variant name in the examcard"));
				dtiScanName.setMandatory(true);
				examParams.add(refScanName = new ParamString("refScanName - the reference seqeuence variant name in the examcard"));
				refScanName.setMandatory(true);
				inputParams.add(examParams);
				
				//Scanner params
				ParamCollection scannerParams = new ParamCollection("Scanner");
				List<String> fields = new ArrayList<String>(2);
				fields.add("3 Tesla");
				fields.add("7 Tesla");
				scannerParams.add(fieldStrength=new ParamOption("fieldStrength - main field strength in gauss",fields));	//B0 field strength (7T or 3T)
				fieldStrength.setMandatory(true);
				List<String> coils = new ArrayList<String>(5);
				coils.add("SENSE-Head-7T");
				coils.add("RX-Intf-1");
				coils.add("SENSE-Head-8");
				coils.add("SENSE-NV-16");
				coils.add("SENSE-Breast-4");
				scannerParams.add(coilSelection = new ParamOption("coilSelection - the type of coil used",coils));
				coilSelection.setMandatory(true);
				scannerParams.add(epiCorrection = new ParamBoolean("runEPICorrection - run epi correction",true));
				epiCorrection.setMandatory(false);	
				scannerParams.add(deltaManual = new ParamInteger("detlaManual - manual offset correction factor"));
				deltaManual.setMandatory(false);
				scannerParams.add(matchSMAPposition = new ParamBoolean("matchSMAPposition - do you want to amtch the smap and the image position",true));
				matchSMAPposition.setMandatory(false);
				inputParams.add(scannerParams);
				
				//Patient Geometry
				ParamCollection geometry = new ParamCollection("Geometry");
				List<String> geom = new ArrayList<String>(4);
				geom.add("supine");
				geom.add("prone");
				geom.add("rightdecubitus");
				geom.add("leftdecubitus");
				geometry.add(patientGeometry=new ParamOption("patientGeometry - the geometry of the patient",geom));	
				patientGeometry.setMandatory(true);
				List<String> pos = new ArrayList<String>(2);
				pos.add("headfirst");
				pos.add("feetfirst");
				geometry.add(patientPosition=new ParamOption("patientPosition - the poisition of the patient",pos));	
				patientPosition.setMandatory(true);
				List<String> geo_type = new ArrayList<String>(6);
				geo_type.add("optic_nerve");
				geo_type.add("spinal_cord");
				geo_type.add("brain");
				geo_type.add("leg");
				geo_type.add("phantom");
				geo_type.add("auditory_canal");
				geometry.add(anatomyType = new ParamOption("anatomy_s - the type of anatomy that was scanned",geo_type));
				inputParams.add(geometry);
				
				//SMAP Params
				ParamCollection smap = new ParamCollection("SMAP");
				List<String> smapOpts = new ArrayList<String>(2);
				smapOpts.add("12p");
				smapOpts.add("tps");
				smap.add(coilSensitivityFit = new ParamOption("sensitivityFit - method for fitting the sensitivity map",smapOpts));
				coilSensitivityFit.setMandatory(true);
				List<String> smapCoilOpts = new ArrayList<String>(2);
				smapCoilOpts.add("body");
				smapCoilOpts.add("ref");
				smap.add(coilGeneralCoil = new ParamOption("sensitivityCoil - coild type used",smapCoilOpts));
				
				smap.add(fitOrder = new ParamInteger("fitOrder - the polynomial fit order (default =2)",2));
				smap.add(fitSizeOut = new ParamInteger ("fitSizeOut - supporting region outside object (default=5)",5));
				smap.add(fitSizeIn = new ParamInteger ("fitSizeIn - supporting region inside object (default=5)",5));
				smap.add(voxDilate= new ParamInteger ("voxDilate - number of voxels to dilate (default=15)",15));
				smap.add(voxErode = new ParamInteger ("voxErode - number of voxels to erode (default=1)",1));
				inputParams.add(smap);
					
				//Reconstruction Params
				ParamCollection recon = new ParamCollection("RECON");
				recon.add(phaseCorrection = new ParamBoolean("phaseCorrection - run phase nav phase correction"));
				phaseCorrection.setMandatory(true);
				recon.add(navFmapCorrection = new ParamBoolean("navFmapCorrection - use fieldmap correction on nav and recon img"));
				navFmapCorrection.setMandatory(true);
				recon.add(navDeform = new ParamBoolean("navDeform - use deformation of navigator on img"));
				navDeform.setMandatory(true);
				recon.add(navEPIFactor = new ParamInteger("navEPIFactor - the navigator scan EPI factor",17));
				navEPIFactor.setMandatory(true);
				recon.add(psiMethod = new ParamInteger("psiMethod - the method to use for noise correlation"));
				psiMethod.setMandatory(true);
				recon.add(calcDiff = new ParamBoolean("calfDiff - calculate FA and MD etc"));
				calcDiff.setMandatory(true);
				recon.add(precalcEncodingMTX = new ParamBoolean("precalcEncodingMTX - precalculate the encoding matrix",false));
				precalcEncodingMTX.setMandatory(false);
				recon.add(useSubEncodingMTX = new ParamBoolean("useSubEncMtx - use the subencoding matrix",false)); //use the subencoding matrix
				useSubEncodingMTX.setMandatory(false);
				recon.add(subEncodingMTXSz = new ParamInteger("subEncMtxSz - the size of the subencoding matrix",0));  //size of the subencoding matrix
				subEncodingMTXSz.setMandatory(false);
				List<String> refOpts = new ArrayList<String>(2);
				refOpts.add("phc");
				refOpts.add("phx");
				recon.add(refEPIType = new ParamOption("refEPIType - the type of reference epi scan",refOpts));
				recon.add(readREF = new ParamBoolean("readREF - should the ref data be read",true));
				recon.add(readDWI = new ParamBoolean("readDWI - should the dwi data be read",true));
				recon.add(genSMAP = new ParamBoolean("genSMAP - should the smap be generated",true));
				recon.add(genFMAP = new ParamBoolean("genFMAP - should the fmap be generated",true));

				inputParams.add(recon);
				
				//Coregistration
				ParamCollection reg = new ParamCollection("REG");
				List<String> opt = new ArrayList<String>(2);
				opt.add("powell");
				opt.add("simplex");
				reg.add(optim = new ParamOption("optim - the optimizer for registration",opt));
				optim.setMandatory(true);
				List<String> meth = new ArrayList<String>(2);
				meth.add("rigid");
				meth.add("affine");
				reg.add(method = new ParamOption("method - the method of registration",meth));
				method.setMandatory(true);
				List<String> cst = new ArrayList<String>(5);
				cst.add("nmi");
				cst.add("mi");
				cst.add("ncc");
				cst.add("ecc");
				cst.add("cor");
				reg.add(method = new ParamOption("cost - the registration cost function",cst));
				reg.add(resizeDTI = new ParamBoolean("resizeDTI - resize the DTI data",true));
				resizeDTI.setMandatory(false);
				reg.add(resizeDTIFactor = new ParamInteger("resizeDTIFactor - the scaling factor to resize the DTI data"));
				resizeDTIFactor.setMandatory(true);
				inputParams.add(reg);
				
				//Tensor
				ParamCollection tens = new ParamCollection("TENSOR");
				tens.add(medFilt = new ParamBoolean("medFilt - run median filtering on tensor calculation"));
				medFilt.setMandatory(true);
				tens.add(filtSize = new ParamInteger("filtSize - the size of the neighboring filter [n x n]",2));
				filtSize.setMandatory(false);
				inputParams.add(tens);
				
				//ZOOM
				ParamCollection zm = new ParamCollection("ZOOM");
				zm.add(zoom = new ParamBoolean("zoom - was zoom mode used in acquisition"));
				zoom.setMandatory(true);
				inputParams.add(zm);
				
				//Parallel Computing
				ParamCollection pc = new ParamCollection("PCT");
				pc.add(pct = new ParamBoolean("pct - use parallel computing toolbox in matlab"));
				pct.setMandatory(true);
				inputParams.add(pc);				
				
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(matlabSTDERR = new ParamFile("Matlab STDERR"));
		matlabSTDERR.setMandatory(true);
		outputParams.add(matlabSTDOUT = new ParamFile("Matlab STDOUT"));
		matlabSTDOUT.setMandatory(true);
		outputParams.add(matlabBatch = new ParamFile("Batch description file"));
		matlabBatch.setMandatory(true);
		
		//Unregistereted Contrasts
		outputParams.add(fa3D = new ParamFile("3D fa mat file"));
		fa3D.setMandatory(false);
		outputParams.add(fa4D = new ParamFile("4D fa mat file"));
		fa4D.setMandatory(false);
		outputParams.add(eigval = new ParamFile("4d eigenvalue mat file"));
		eigval.setMandatory(false);
		outputParams.add(eigvec= new ParamFile("5d eigenvector mat file"));
		eigvec.setMandatory(false);
		outputParams.add(md= new ParamFile("3D mean diffusivity mat file"));
		md.setMandatory(false);
		outputParams.add(residuals= new ParamFile("Residual fmap mat file"));
		residuals.setMandatory(false);
		
		//Registered Contrasts
		outputParams.add(regfa3D = new ParamFile("registered3D fa mat file"));
		regfa3D.setMandatory(false);
		outputParams.add(regfa4D = new ParamFile("registered4D fa mat file"));
		regfa4D.setMandatory(false);
		outputParams.add(regeigval = new ParamFile("registered4d eigenvalue mat file"));
		regeigval.setMandatory(false);
		outputParams.add(regeigvec= new ParamFile("registered5d eigenvector mat file"));
		regeigvec.setMandatory(false);
		outputParams.add(regmd= new ParamFile("registered3D mean diffusivity mat file"));
		regmd.setMandatory(false);
		outputParams.add(regresiduals= new ParamFile("registeredResidual fmap mat file"));
		regresiduals.setMandatory(false);
		
		outputParams.add(I_fmap = new ParamFile("I field map mat file"));
		I_fmap.setMandatory(false);
		outputParams.add(I_smap = new ParamFile("I sensitivity map file"));
		I_smap.setMandatory(false);
		outputParams.add(dwDataori01 = new ParamFile("diffusion weighted data for orientation 1"));
		dwDataori01.setMandatory(false);
		outputParams.add(reconNavWinFmap = new ParamFile("reconstructed windowed navigator map"));
		reconNavWinFmap.setMandatory(false);
		outputParams.add(reconNavWinOri = new ParamFile("reconstructed windowed orientation file"));
		reconNavWinOri.setMandatory(false);
		outputParams.add(reconImgCorrFmap = new ParamFile("reconstructed Img fieldmap"));
		reconImgCorrFmap.setMandatory(false);
		outputParams.add(p1 = new ParamFile("p1 file"));
		p1.setMandatory(false);
		outputParams.add(iAliasSense01 = new ParamFile("I aliased sense file"));
		iAliasSense01.setMandatory(false);
		
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		MSHDTIUtil util = new MSHDTIUtil();
		util.initBatch(inputParams, new File(System.getProperty("user.dir")), this.getOutputDirectory());
		System.out.println(System.getProperty("user.dir"));
		Process p;
		int exitStatus =0;
		File thisStdErr = new File(String.format("%s%smatlab.err",this.getOutputDirectory(),File.separator));
		File thisStdOut = new File(String.format("%s%smatlab.out",this.getOutputDirectory(),File.separator));
		String ln="";
		
		JistLogger.logOutput(JistLogger.FINE, "Booting up MATLAB");
		try{
			String cmd = String.format("matlab -nodesktop -nosplash -r s_batch");
			System.out.println();
			p = Runtime.getRuntime().exec(cmd);
			p.waitFor();
		}catch(Exception e){
		}
		JistLogger.logOutput(JistLogger.FINE, "Closing MATLAB");
		
//		try{
//			
//		
//			
//			BufferedWriter writerErr = new BufferedWriter(new FileWriter(thisStdErr));
//			BufferedWriter writerOut = new BufferedWriter(new FileWriter(thisStdOut));
//			BufferedReader errstream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
//			BufferedReader outstream = new BufferedReader(new InputStreamReader(p.getInputStream()));
//		       while ((ln = errstream.readLine()) != null) {
//		    	   writerErr.write(ln+"\n");
//		       }
//		       ln="";
//		       while ((ln = outstream.readLine()) != null) {
//		    	   writerOut.write(ln+"\n");
//		       }
//		       errstream.close();
//		       writerErr.close();
//		       errstream.close();
//		       writerOut.close();
//		       
//			p.waitFor();
//			exitStatus = p.exitValue();
//			JistLogger.logOutput(JistLogger.FINE, "MATLAB COMPLETE");
//			if (exitStatus!=0){
//				throw new RuntimeException(this.getAlgorithmName()+" Failed with exit status "+String.valueOf(exitStatus));
//			}
//		} catch (IOException e) {
//			JistLogger.logError(JistLogger.SEVERE, "FATAL: IOException caught during execution. Please check debug.out");
//			e.printStackTrace();
//		} catch (InterruptedException e) {
//			JistLogger.logError(JistLogger.SEVERE, "FATAL: InterruptedException caught during execution. Please check debug.out");
//			e.printStackTrace();
//		}
//		
//		setOutputs();
		
		
	}
	
	private void setOutputs(){
		
		
		File reconDir_noreg = new File(this.getOutputDirectory(),"recon");
		File reconDir_reg = new File(reconDir_noreg,"reg");
		
		if (calcDiff.getValue()){
			
			//Unregistereted Contrasts
			fa3D.setValue(new File(reconDir_noreg,"fa_fmap_reg_3d.mat"));
			fa4D.setValue(new File(reconDir_noreg,"fa_fmap_reg_4d.mat"));
			eigval.setValue(new File(reconDir_noreg,"eigval_fmap_reg_4d.mat"));
			eigvec.setValue(new File(reconDir_noreg,"eigvec_fmap_reg_5d.mat"));
			md.setValue(new File(reconDir_noreg,"meanDiff_fmap_reg_3d.mat"));
			residuals.setValue(new File(reconDir_noreg,"residual_fmap_reg_4d.mat"));
			
			//Registered Contrasts
			regfa3D.setValue(new File(reconDir_reg,"fa_fmap_reg_3d.mat"));
			regfa4D.setValue(new File(reconDir_reg,"fa_fmap_reg_4d.mat"));
			regeigval.setValue(new File(reconDir_reg,"eigval_fmap_reg_4d.mat"));
			regeigvec.setValue(new File(reconDir_reg,"eigvec_fmap_reg_5d.mat"));
			regmd.setValue(new File(reconDir_reg,"meanDiff_fmap_reg_3d.mat"));
			regresiduals.setValue(new File(reconDir_reg,"residual_fmap_reg_4d.mat"));
			
		}
		
		if (genFMAP.getValue()){
			I_fmap.setValue(new File(this.getOutputDirectory(),"I_fmap.mat"));
		}
		if (genSMAP.getValue()){
			I_smap.setValue(new File(this.getOutputDirectory(),"I_smap_4d.mat"));
		}
		dwDataori01.setValue(new File(this.getOutputDirectory(),"dw_data_ori00_row00.mat"));
		if (refSSHPAR.getValue()!=null & refSSHREC.getValue()!=null && navFmapCorrection.getValue()){
			reconNavWinFmap.setValue(new File(reconDir_noreg,"recon_nav_win_fmap_ori00.mat"));
			reconNavWinOri.setValue(new File(reconDir_noreg,"recon_nav_win_ori00_row00.mat"));
		}
		reconImgCorrFmap.setValue("recon_img_corr_fmap_avg06_ori00_row00.mat");
		p1.setValue(new File(reconDir_noreg,"p1_v__sl01_chunk01_dw01_avg01.mat"));
		iAliasSense01.setValue(new File(this.getOutputDirectory(),"I_alias_sense_sl01_ori00_row00.mat"));
		
		
		
	}
}
