package edu.vanderbilt.masi.plugins.external;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.algorithms.external.ExternalModuleBuilder;
import edu.vanderbilt.masi.algorithms.external.JSONValidate;

import org.json.*;

public class PluginRunExternalCli extends ProcessingAlgorithm{
	ParamFileCollection inputDef;
	ParamFile outputCalls; 
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.7 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Run External CLI programs";
	private static final String longDescription = "JIST module that loads a json file and reconstructs the algorithm to run from an external piece of software";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		// TODO Auto-generated method stub
		inputParams.add(inputDef = new ParamFileCollection("List of json files to run"));
		inputParams.setMandatory(true);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("External.CliAdapter");
		inputParams.setLabel("External CLI Adapter");
		inputParams.setName("External_CLI_Adapter");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("MASI","Steve Damon","Electrical Engineering"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.ALPHA);
		
		
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outputCalls = new ParamFile("List of strings that were executed"));
		
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		for (int i=0; i<inputDef.size();i++){

			System.out.println("TSET");	
			File theOutputPath = this.getOutputDirectory();
			ExternalModuleBuilder builder = new ExternalModuleBuilder(inputDef.getValue(i),theOutputPath);
			File theModule = builder.getPluginFile();
			outputCalls.setValue(theModule);
			


	}
		
	}

}
