package edu.vanderbilt.masi.plugins.labelfusion;

import java.io.FileNotFoundException;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.algorithms.labelfusion.IdealHierarchicalSTAPLE;
import edu.vanderbilt.masi.algorithms.labelfusion.IdealSTAPLE;
import edu.vanderbilt.masi.algorithms.labelfusion.ObservationBase;
import edu.vanderbilt.masi.algorithms.labelfusion.StatisticalFusionBase;

public class PluginIdealStatisticalFusion extends AbstractStatisticalFusionPlugin {
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Runs the Generalized Statistical Label Fusion Algorithm using the Ideal Performance Estimate.";
	private static final String longDescription = "";
	
	public transient ParamVolume truthvol;
	
	/*
	 * (non-Javadoc)
	 *
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#createInputParameters(edu.jhu.ece.iacl.pipeline.parameter.ParamCollection)
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Asman","andrew.j.asman@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Asman"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setLabel("Ideal Generalized Statistical Fusion");
		inputParams.setName("Ideal_Generalized_Statistical_Fusion");
		
		// set the input rater observations
		inputParams.add(truthvol=new ParamVolume("True Labels"));
		truthvol.setLoadAndSaveOnValidate(false);
		truthvol.setMandatory(true);
		
		inputParams.add(get_main_parameters());
		inputParams.add(get_weighting_parameters());
		
		// these aren't mandatory for this plugin
		targetim.setMandatory(false);
		imsvols.setMandatory(false);
	}
	
	/*
	 * (non-Javadoc)
	 *
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#createOutputParameters(edu.jhu.ece.iacl.pipeline.parameter.ParamCollection)
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.setName("Generalized_Statistical_Fusion_Output");
		
		set_output_parameters();
	}
	
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		try {
			ExecuteWrapper wrapper=new ExecuteWrapper();
			monitor.observe(wrapper);
			wrapper.execute(this);

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	protected class ExecuteWrapper extends AbstractExecuteWrapper {
		
		protected StatisticalFusionBase get_statistical_fusion_type(ObservationBase obs, ProcessingAlgorithm alg) {

			StatisticalFusionBase sf;
			String algname = alg.getAlgorithmName();
			
			JistLogger.logOutput(JistLogger.INFO, "*** Determining appropriate type for the statistical fusion object. ***");
			
			boolean useHierarchy = hierarchy_file != null && hierarchy_file.getValue() != null;
			
			if (useHierarchy)
				sf = new IdealHierarchicalSTAPLE(truthvol,
											     obs,
											     epsilon.getFloat(),
											     maxiter.getInt(),
											     priortype_index,
											     hierarchy_file.getValue(),
											     String.format("%s_Estimate", algname));
			else
				sf = new IdealSTAPLE(truthvol, 
									 obs,
									 epsilon.getFloat(),
									 maxiter.getInt(),
									 priortype_index,
									 String.format("%s_Estimate", algname));
						
			return(sf);
		}
	}
}
