package edu.vanderbilt.masi.plugins.labelfusion;

import java.io.File;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.algorithms.labelfusion.InitialProbabilityCalculator;

public class PluginInitialProbabilityCalculator extends ProcessingAlgorithm {
	
	private static final String cvsversion = "$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Calculates an initial probability matrix for Multi-Class STAPLE";
	private static final String longDescription = "";
	
	//Input Parameters
	ParamVolumeCollection images;
	ParamFile raterMap;
	
	//Output Parameters
	ParamFile thetaFile;

	@Override
	protected void createInputParameters(ParamCollection arg0) {
		// TODO Auto-generated method stub
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.ALPHA);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setName("Initial_Theta_Calculator");
		inputParams.setLabel("Initial Theta Calculator");
		
		inputParams.add(images = new ParamVolumeCollection("Registered Images"));
		inputParams.setMandatory(true);
		
		inputParams.add(raterMap = new ParamFile("Rater Map File"));
		inputParams.setMandatory(true);

	}

	@Override
	protected void createOutputParameters(ParamCollection arg0) {
		outputParams.add(thetaFile = new ParamFile("Initial Probabilities Files"));

	}

	@Override
	protected void execute(CalculationMonitor arg0)
			throws AlgorithmRuntimeException {
		
		File outDir = new File(
				this.getOutputDirectory() +
				File.separator +
				FileUtil.forceSafeFilename(this.getAlgorithmName()) +
				File.separator);
		InitialProbabilityCalculator IPC = new InitialProbabilityCalculator(images,raterMap,outDir);
		IPC.run();
		thetaFile.setValue(IPC.getThetaFile());
		

	}

}
