package edu.vanderbilt.masi.plugins.labelfusion;

import java.io.File;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import edu.vanderbilt.masi.algorithms.labelfusion.InitialProbabilityCalculator2;

public class PluginInitialVotingProbabilityCalculator extends
ProcessingAlgorithm {

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Calculates an initial probability matrix for Multi-Set Voting";
	private static final String longDescription = "";

	//Input Parameters
	ParamVolumeCollection images;
	ParamFile raterMap;

	//Output Parameters
	ParamFile thetaFile;

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.ALPHA);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setName("Initial_Voting_Probability_Calculator");
		inputParams.setLabel("Initial Voting Probability Calculator");
		
		inputParams.add(images = new ParamVolumeCollection("Registered Images"));
		inputParams.setMandatory(true);
		
		inputParams.add(raterMap = new ParamFile("Rater Map File"));
		inputParams.setMandatory(true);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(thetaFile = new ParamFile("Initial Probabilities Files"));

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		File outDir = new File(
				this.getOutputDirectory() +
				File.separator +
				FileUtil.forceSafeFilename(this.getAlgorithmName()) +
				File.separator);
		
		InitialProbabilityCalculator2 IPC = new InitialProbabilityCalculator2(images,raterMap,outDir);
		IPC.run();
		thetaFile.setValue(IPC.getThetaFile());

	}

}
