package edu.vanderbilt.masi.plugins.labelfusion;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.vanderbilt.masi.algorithms.labelfusion.simple.LocalSIMPLE;
import edu.vanderbilt.masi.algorithms.labelfusion.simple.LocalSpatialSIMPLE;
import edu.vanderbilt.masi.algorithms.labelfusion.simple.SIMPLE;
import edu.vanderbilt.masi.algorithms.labelfusion.simple.SIMPLEBase;
import edu.vanderbilt.masi.algorithms.labelfusion.simple.SpatialSIMPLE;

public class PluginSIMPLE extends ProcessingAlgorithm{

	private static final String cvsversion = "$Revision: 1.7 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Runs the SIMPLE Label Fusion Algorithm.";
	private static final String longDescription = "";

	//inputs
	public ParamVolumeCollection obsLabs;
	public ParamVolume targetImage;
	public ParamVolumeCollection obsImgs;
	public ParamInteger poolRegion;
	public ParamInteger numIter;
	public ParamFloat epsilon;

	//outputs
	public ParamVolume segmentation;

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.BETA);

		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setName("SIMPLE");
		inputParams.setLabel("SIMPLE");

		inputParams.add((this.obsLabs = new ParamVolumeCollection("Input Label Volumes")));
		obsLabs.setMandatory(true);
		inputParams.add((this.targetImage = new ParamVolume("Target Image")));
		this.targetImage.setMandatory(false);
		inputParams.add((this.obsImgs = new ParamVolumeCollection("Atlas Image Volumes")));
		this.obsImgs.setMandatory(false);
		inputParams.add((this.poolRegion = new ParamInteger("Pool Regions (-1 is whole image)")));
		poolRegion.setValue(10);
		poolRegion.setMandatory(false);
		inputParams.add((this.numIter = new ParamInteger("Maximum number of iterations")));
		numIter.setValue(10);
		numIter.setMandatory(false);
		inputParams.add((this.epsilon = new ParamFloat("Value to evaluate convergence at")));
		epsilon.setValue(1e-4);
		epsilon.setMandatory(false);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add((this.segmentation=new ParamVolume("Resultant Segmentation")));

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		SIMPLEBase slf;
		if((poolRegion.getInt() < 0 || poolRegion.getInt() == 999) &&
				(this.obsImgs.getImageDataList().size() ==0 || this.targetImage.getImageData() == null))
			slf = new SIMPLE(this.obsLabs.getImageDataList(),
					numIter.getInt(),epsilon.getFloat());
		else if((poolRegion.getInt() < 0 || poolRegion.getInt() == 999))
			slf = new LocalSIMPLE(obsLabs.getImageDataList(), obsImgs.getImageDataList(), 
					targetImage.getImageData(), numIter.getInt(), epsilon.getFloat());
		else if(this.obsImgs.getImageDataList().size() !=0 && this.targetImage != null)
			slf = new LocalSpatialSIMPLE(obsLabs.getImageDataList(), obsImgs.getImageDataList(),
					targetImage.getImageData(), poolRegion.getInt(), numIter.getInt(), epsilon.getFloat());
		else
			slf = new SpatialSIMPLE(this.obsLabs.getImageDataList(),
					poolRegion.getInt(),numIter.getInt(),epsilon.getFloat());
		slf.run();
		segmentation.setValue(slf.getSegmentation());
	}

}
