package edu.vanderbilt.masi.plugins.regression;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class PluginRegressionForest extends ProcessingAlgorithm {
	/**
	 * Input Parameters
	 */
	private ParamFloat a;	
	private ParamFloat b;
	
	/**
	 * Output Parameters
	 */
	private ParamFile result;
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Demo.";
	private static final String longDescription = "It's a demo.";
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		// Set plugin information
		inputParams.setPackage("MASI");
		inputParams.setCategory("Regression");
		inputParams.setLabel("Regression Mini Demo");
		inputParams.setName("Regression Demo");
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Ray Ge","rayge021@vanderbilt.edu",""));
		info.setAffiliation("Vanderbilt University");
		info.setDescription(shortDescription + longDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.add(new Citation(""));
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);
		
		// Set input parameters to control the system
		inputParams.add(a = new ParamFloat("a",1));
		inputParams.add(b = new ParamFloat("b",7));
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(result = new ParamFile("Regression Values",new FileExtensionFilter(new String[]{"txt"})));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		AlgorithmWrapper wrapper=new AlgorithmWrapper();
		monitor.observe(wrapper);
		wrapper.execute(this);		
	}
	
	protected class AlgorithmWrapper extends AbstractCalculation {

		public void execute(ProcessingAlgorithm parent) {
			this.setLabel("PARSING INPUTS");
			
			// Indicate that the Plugin has started.
			JistLogger.logOutput(JistLogger.INFO, "PLUGIN STARTED");
			
			double c = a.getDouble() + b.getDouble();
			String f = getOutputDirectory().getAbsoluteFile().toString();
			File resultFile = new File(f + "/" + result.getName() + ".txt");
			
			try {
				@SuppressWarnings("resource")
				PrintWriter out = new PrintWriter(resultFile);
				out.println(c);
				out.close();
			} catch (IOException e) {
				System.err.println(getClass().getCanonicalName()+e.getMessage());
				return;
			}
			
			JistLogger.logOutput(JistLogger.INFO, "SETTING UP EXPORTS");
			result.setValue(resultFile);
			JistLogger.logOutput(JistLogger.INFO, "FINISHED");
		}
		
	}
}
