package edu.vanderbilt.masi.plugins.utilities;

import java.io.File;
import java.io.FileNotFoundException;

import edu.jhu.ece.iacl.jist.io.FileReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;

public class PluginCopyVolume extends ProcessingAlgorithm {
	
	// input parameters
	public ParamVolume in_file;
	public ParamFile ref_file;
	public ParamFile out_dir;
	public ParamString append_str;
	public ParamString prepend_str;
	
	// output parameters
	public ParamVolume out_file;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Copies input volume to specified output directory.";
	private static final String longDescription = "";
	
	/*
	 * (non-Javadoc)
	 *
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#createInputParameters(edu.jhu.ece.iacl.pipeline.parameter.ParamCollection)
	 */
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Asman","andrew.j.asman@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Asman"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Utilities");
		inputParams.setLabel("Copy Volume");
		inputParams.setName("Copy_Volume");
		
		// set the truth volume
		inputParams.add(in_file=new ParamVolume("Input Volume"));
		in_file.setLoadAndSaveOnValidate(false);
		
		// set the output directory
		inputParams.add(out_dir = new ParamFile("Directory", ParamFile.DialogType.DIRECTORY));
		out_dir.setMandatory(true);
		
		// set the reference file
		inputParams.add(ref_file=new ParamFile("Reference File (for Basename)"));
		ref_file.setMandatory(false);
		
		inputParams.add(prepend_str=new ParamString("Prepend String", new String("")));
		prepend_str.setMandatory(false);
		inputParams.add(append_str=new ParamString("Append String", new String("")));
		append_str.setMandatory(false);
		
	}
	
	/*
	 * (non-Javadoc)
	 *
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#createOutputParameters(edu.jhu.ece.iacl.pipeline.parameter.ParamCollection)
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(out_file = new ParamVolume("Copied Volume"));
		out_file.setLoadAndSaveOnValidate(false);
	}
	
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		try {
			ExecuteWrapper wrapper=new ExecuteWrapper();
			monitor.observe(wrapper);
			wrapper.execute(this);

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	protected class ExecuteWrapper extends AbstractCalculation {
		public void execute(ProcessingAlgorithm alg) throws FileNotFoundException{
			
			// set the base string
			String base_str;
			if (ref_file.getValue() != null)
				base_str = get_output_name(ref_file.getValue());
			else
				base_str = get_output_name(in_file.getValue());
			
			// set the final output name
			String name = prepend_str.getValue() + base_str + append_str.getValue();
			
			// copy the data
			out_file.setValue(in_file.getImageData(true).clone());
			out_file.getImageData().setHeader(in_file.getImageData(true).getHeader().clone());
			out_file.getImageData().setName(name);
			out_file.writeAndFreeNow(out_dir.getValue());

		}
		
		public String get_output_name(File f) {
			// get the the original filename
			String pfix = f.getName();
			
			// try to get the prefix
			if (pfix.endsWith(".gz") || pfix.endsWith(".bz2"))
				pfix = FileReaderWriter.getFileName(pfix);
			pfix = FileReaderWriter.getFileName(pfix);
			
			// return the prefix
			return(pfix);
		}
	}

}
