package bl.diffusion;

/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 20, 2005
 * Time: 11:12:10 AM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * class IntersectResult
 *      Store the results associated with detecting an intersection.
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public class IntersectResult {
	public static double EPSILON = 1e-3; // 1nm
    public PT intersectionPoint;   // store the point of intersection
    public PT epsilonForward;
    public PT epsilonBackward;
    public double fractionalDistance; // store the fractional distance between the ends of a line segement until intersection
    public PT intersectionNormal; //normal vector at point of intercept

    // Create a new IntersectionResult
    public IntersectResult(PT a, double s, PT norm, PT fwd, PT bck) {
        intersectionPoint = a;
        fractionalDistance = s;
        intersectionNormal = norm;        
        epsilonForward=fwd;
        epsilonBackward=bck;
        
        if(s<=0 || s>1)
        	throw new RuntimeException("arg:"+s);
    }
}
