package bl.diffusion;

import Jama.Matrix;
public class SimCompartmentTransform implements SimCompartment {

	private SimCompartment myCompartment;	
	Matrix xfm, invXfm;
	private double T2; 
	public double getT2() {return T2;};
private double transmissionProb;
private double diffusionCoef;
	// 
	public SimCompartmentTransform(SimCompartment base, double [][]affineTransform, 
			double T2, double transmissionProb, double diffusionCoef) {
		this.T2=T2;
		this.transmissionProb = transmissionProb;
		this.diffusionCoef = diffusionCoef;
		myCompartment = base;
		xfm = new Matrix(affineTransform);
		invXfm = xfm.inverse();		
	}

	private PT transformFWD(PT p) {
		return p.times(xfm);
	}
	private PT transformREV(PT p) {
		return p.times(invXfm);
	}

	public boolean contains(PT p) {
		return myCompartment.contains(transformFWD(p)); 
	}


	public IntersectResult findFirstIntersection(PT a, PT b) {
		IntersectResult r = myCompartment.findFirstIntersection(transformFWD(a),transformFWD(b));
		if(r==null)
			return null;
		return new IntersectResult(transformREV(r.intersectionPoint),r.fractionalDistance,transformREV(r.intersectionNormal),
				transformREV(r.epsilonForward), transformREV(r.epsilonBackward));
	}

	// return the membrane transmission probability
	public double getMembranePermeability() {
		return transmissionProb;
	}

	// return the compartment diffusion coefficient
	public double getDiffusionCoefficient() {
		return diffusionCoef;
	}

}
