package bl.diffusion;

import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 20, 2005
 * Time: 10:00:17 AM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * interface SimEnvironment
 *      Provide a generic interface between a compartment and the environment
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public interface SimEnvironment {
    // Ask the environemtn for the local compartment of a point
    public SimCompartment getLocalEnvironment(PT newPt, SimCompartment lastEnv);

    // Return all compartments that could intersect the segment from currentPosition to nextPosition
    public Iterator getPossibleCollisionIterator(PT currentPosition, PT nextPosition, SimCompartment curEnv);

    // Return the transmission probability
    public double calcTransmissionProb(SimCompartment localEnv, SimCompartment newEnv);

    // request that a point be updated.
    public void updateSimPointEnv(SimPoint simPoint, SimCompartment newEnv);

    // Check to see if the segment curPt->nextPT wraps around the lattice element
    IntersectResult checkLatticeWrapAround(IntersectResult firstHit, PT curPT, PT nextPT);
    
 // Check to see if the segment curPt->nextPT wraps around the lattice element
    boolean checkLatticeWrapAround(PT pt);
    
    // Return the extracelluar T2 in us
    public double getT2(); 
}
