% ====================
% TEST FREE DIFFUSION
% ====================
clear all java
javaaddpath([fileparts(mfilename('fullpath')) filesep 'bin'])
javaaddpath([pwd filesep 'bin'])
import bl.diffusion.*;
T2=100e3;
modelFilename = 'Model_UnconstrainedGaussian.mat';
modelFilename = 'Model_NerveUnmylenated.mat';
load(modelFilename);
T2=100e3; %us
diffusionModel.Geometry.javaObject = SimCompartmentCylinder(PT(1.5,1.5,1.5), .5,10, 0,2e-3,T2);
%diffusionModel.Geometry.javaObject = SimCompartmentSphere(PT(.5,.5,.5), .333, 0,1e-3);
% 
% load test
% q=diffusionModel.Geometry.javaObject.findFirstIntersection(PT(a(1),a(2),a(3)),PT(b(1),b(2),b(3)))
% q.intersectionPoint
% return
% return
numSpinPackets = 10; %number of packets
NSteps=1;
diffusionTimeMS = linspace(0,100,NSteps+1); %ms
diffusionTimeMS =diffusionTimeMS (2:end);
timeStepUS = 1; %us


% Convert times arguments to stanard units:
diffusionTimeUS = diffusionTimeMS(end)*1000/NSteps; % ms -> us

% 1) Initialize Java Simulator
import bl.diffusion.*;
javaSimulator = RandomWalkSimulator;
javaSimulator.intenseDebug=0;
javaSimulator.setSimTime(timeStepUS,diffusionTimeUS);

% 2) set the lattice and global information
javaSimulator.setLatticeInfo(diffusionModel.extraComparmentDiffusivity, ... %UM2pUS
    diffusionModel.latticeDimensions(1),...%um
    diffusionModel.latticeDimensions(2),... %um
    diffusionModel.latticeDimensions(3),... %um
    T2); %T2 in us

% 3) Enter the geometries
for j=1:length(diffusionModel.Geometry)
    if(isfield(diffusionModel.Geometry,'javaObject'))
        javaSimulator.createCompartment(diffusionModel.Geometry.javaObject);
    else
        geo = diffusionModel.Geometry(j);
        res=javaSimulator.createCompartment(geo.diffusivity, geo.permeability, geo.shape.vertices, geo.shape.faces-1,T2);
    end
end

% 4) select number of spins
javaSimulator.setNumberSpins(numSpinPackets);

% 4B) Initialize the spins (select one)
%javaSimulator.initializeRandomSpins();
% javaSimulator.initializeRandomSpinsInside();
% javaSimulator.initializeRandomSpinsOutside();
%javaSimulator.initializeFixedSpins(positionUM); % Note positionUM = 1x3 vector of positions in um
javaSimulator.initializeFixedSpins([.5,.5,.5])
%resultPositions = javaSimulator.reportResultPositions();
% figure, scatter3(resultPositions(:,1),resultPositions(:,2),resultPositions(:,3)); axis([0 1 0 1 0 3])
% pause;
% javaSimulator.setSimTime(timeStepUS,timeStepUS);
% P=[.5,.5,.5];
% javaSimulator.setSimTime(timeStepUS,timeStepUS);
% while(1)
% 
%     javaSimulator.takeAWalk();
%     P(end+1,:) = javaSimulator.reportResultPositions-javaSimulator.reportOriginalPositions;
%     figure(1)
%     plot3(P(:,1),P(:,2),P(:,3))
%     axis equal
% %     axis([0 1 0 1 0 1]*3)
% axis equal tight on
%     pause(.001);
% end

if(1)
    for ii = 1:length(diffusionTimeMS)

        % 5) simulate the random walks (non-interacting)
        tic;
        javaSimulator.takeAWalk();
        stats= javaSimulator.getCollisionStats();
        stats=single(stats);
        disp(sprintf('Stats: %d collisions in %d steps (%.2f%%)',stats(1),stats(2),stats(1)/stats(2)*100))
        time = toc;

        % 6) read out results
        resultPositions = javaSimulator.reportResultPositions();
        origPositions = javaSimulator.reportOriginalPositions();
        totalMotion = resultPositions-origPositions;


        % Step 7. Save output
        MotionResults = [];
        MotionResults.parameters.numSpinPackets = numSpinPackets;
        MotionResults.parameters.diffusionTime = diffusionTimeUS*ii; % us
        MotionResults.parameters.timeStep = timeStepUS; %us
        MotionResults.parameters.modelFilename = modelFilename;
        MotionResults.elapseTime = time;
        MotionResults.brownianMotion = totalMotion;
        MotionResults.origPositions = origPositions;
        MotionResults.resultPositions = resultPositions;
        disp(['Simulation Complete in ' num2str(time) ' seconds.']);

        displacement = sqrt(sum(MotionResults.brownianMotion.^2,2));
        rmsd(ii) = sqrt(mean(displacement.^2)); %um

        motionInfo = MotionResults;
        encodingDir = [1 0 0; 0 1 0; 0 0 1];
        delta = 16; %ms
        G = 30; %mT/m
        G = G/100; % mT/cm
        GradLobeArea = delta*G; %(mT/cm)*ms
        [adc(ii,:),signal(ii,:,:)] = simulateADC(motionInfo,encodingDir,GradLobeArea);


    end

    adj_rmsd = rmsd/1000; %mm

    D = diffusionModel.extraComparmentDiffusivity; %mm^2/s
    D = D/1000 % mm^2/ms

    figure(1); clf
    plot(diffusionTimeMS,adj_rmsd,'ro-'), hold on
    plot(diffusionTimeMS,sqrt(6*D*diffusionTimeMS),'k*'), hold on
    xlabel('diffusionTime in ms')
    ylabel('RMSD in mm')
    legend('rand walk','sim from known D',0)


    figure(2); clf
    plot(diffusionTimeMS,adc,'x-'), hold on
    plot(diffusionTimeMS,ones(size(diffusionTimeMS))*D*1e3,'-*'), hold on
    xlabel('diffusionTime in ms')
    ylabel('ADC in um^2/um')
    legend('ADC_x','ADC_y','ADC_z','known D',0)

end