function [compartmentIndex,currentGeometry] = RWSaddCompartment(javaSimulator,compartmentObject,currentGeometry)
% function [compartmentIndex,currentGeometry] =
% RWSaddCompartment(javaSimulator,compartmentObject,currentGeometry)
%
%   Add a restriction compartment to the RWS simulator. Note that it
%   is the users responsibility to ensure appropriate tiling and
%   non-intersection within the tiling environment.
%
%   Inputs:
%       javaSimulator - RWS simulator object
%       compartmentObject - created by RWS compartment system
%       currentGeometry - object returned by last insert. Use [] if this is
%          the first geometry inserted.
%
%   Outputs:
%       compartmentIndex - index of the last compartment inserted. Used to
%           indicate nested compartments
%       currentGeometry - object structure representing current geometry -
%          used for rendering and visualization purposes. 
%
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/10/08 bl

import bl.diffusion.*;

if(isfield(compartmentObject,'javaObject'))
    compartmentIndex=javaSimulator.createCompartment(compartmentObject.javaObject);
else    
    compartmentIndex=javaSimulator.createCompartment(compartmentObject.diffusivity, compartmentObject.permeability, compartmentObject.shape.vertices, compartmentObject.shape.faces-1,compartmentObject.T2);
end
currentGeometry{compartmentIndex+1} = compartmentObject;