function RWSaddSpins(javaSimulator,numSpinPackets,varargin)
% function RWSsetup(javaSimulator,numSpinPackets,placement)
%                     or
% function RWSsetup(javaSimulator,numSpinPackets,'fixed',position)
%
%   Add spins to an exist RWS object.
%
%   Inputs:
%       javaSimulator - RWS simulator object
%       numSpinPackets - number of spins to place
%       placement - String - one of the following
%           'Random' - place spins uniformly at random within the lattice
%           'RandomInside' - place spins uniformly at random within the
%              comparments (not in extracellular space)
%           'RandomOutside' - place spins uniformly at random within the
%              extracellular spce (not in a compartment)
%           'Fixed' - place at the indicated position (requires 'position')
%           position - 3x1 vector within the lattice (in um) - location to
%               place spins at a fixed position.
%
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/10/08 bl

import bl.diffusion.*;


javaSimulator.setNumberSpins(numSpinPackets);
switch(lower(varargin{1}))
    case 'random'
        javaSimulator.initializeRandomSpins();

    case 'randominside'
        javaSimulator.initializeRandomSpinsInside();

    case 'randomoutside'
        javaSimulator.initializeRandomSpinsOutside();
        
    case 'fixed'
        javaSimulator.initializeFixedSpins(varargin{2});
    otherwise
        error('Unknown spin placement');
end