function compartmentGeometry = RWScreateCompartmentMesh(T2,intraCompartmentDiffusivity,membranePermeability,shape)
% function compartmentGeometry  =
% RWScreateCompartmentMesh(intraCompartmentDiffusivity,membranePermeability,shape)
%
%   Create an arbitrary restriction environment based on close polyhedra.
%   Do NOT use reducePath - this function generates polyhedra with cracks
%   and gaps. 
%
%   Inputs:
%       T2 - T2 of the compartment in us
%       intraCompartmentDiffusivity - intra-compartment diffusivity um2/us
%       membranePermeability - um/us
%       shape - a matlab list of faces and vertices appropriate for the
%       patch command.
%       
%
%   Outputs:
%       compartmentGometry - an object to describe the compartment
%       geometry.
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/16/08 bl

import bl.diffusion.*;
poly = Polyhedron(shape.vertices,shape.faces-1); % 0 indexed versus 1 indexed.
compartmentGeometry.javaObject = SimCompartmentPoly(poly, membranePermeability,intraCompartmentDiffusivity,T2);
compartmentGeometry.name= 'Polyhedron';
compartmentGeometry.diffusivity=intraCompartmentDiffusivity;
compartmentGeometry.permeability=membranePermeability;
compartmentGeometry.shape = shape;


