
% PDF Plots
close all
c={'r','g','b','k'};
for m=1:3
    for k=1:2
        figure(k+m*10)
        for j=1:4
            
            for r=1:25,
                [y,x]=ksdensity(MR{j,k,r}.brownianMotion(:,m));
                plot(x,y,c{j});
                hold on;
            end
        end
    end
end

% Calc KE
for m=1:3
    for k=1:2
        figure(k+m*10)
        for j=1:4
            for r=1:25,
                [y,x]=ksdensity(MR{j,k,r}.brownianMotion(:,m));
                mu4 = trapz(x,x.^4.*y);
                sig4 = trapz(x,x.^2.*y).^2;
                KE(m,k,j,r) = mu4/sig4-3;
            end
        end
    end
end

mKE=mean(KE,4);
sKE=std(KE,[],4)/5;
bw_legend = {'2 ms','20 ms'};
groupnames = {'Healthy','Bulge','Crimped','Broken'}
figure(101);
barweb(squeeze(mKE(1,:,:))',squeeze(sKE(1,:,:))', [], groupnames, [], [], 'KE: Kurtosis Excess', bone, [], bw_legend)
figure(103);
barweb(squeeze(mKE(3,:,:))',squeeze(sKE(3,:,:))', [], groupnames, [], [], 'KE: Kurtosis Excess', bone, [], bw_legend)

for i=1:3
    for k=1:4
        [h,p(i,k)] = ttest2(KE(i,1,k,:),KE(i,2,k,:));
    end
end
% for m=1:3
%     figure(100+m)
% bar(squeeze(mKE(m,:,:))'); a=axis;a(3:4)=[-1 2]; axis(a)
% title(m);
% end


Tpoly = tesselatePoly(inscribePlatonicSolid('dodecahedron',1),5);
Tpoly = tesselatePoly(inscribePlatonicSolid('Octahedron',1),8);
g=Tpoly.vert./repmat(sqrt(sum(Tpoly.vert.^2,2)),[1 3]);

xx=linspace(-30,30,250);
clear projMotion PDF
PDF = zeros([258 length(xx) 25 4 2],'single');
for jShape=1:4
    for jT=1:2
        for jRep=1:25
            disp(jRep);
            clear projMotion;
            projMotion = g*MR{jShape,jT,jRep}.brownianMotion';
            for j=1:size(projMotion,1)
                [p,x]  = ksdensity(projMotion(j,:));
                pp = interp1(x,p,xx);
                pp(find(isnan(pp)))=0;
                PDF(j,:,jRep,jShape,jT)=pp;
            end
        end
    end
end


clf;
for i=1:4, hold on,
    plot(xx,100*mean(std(PDF(:,:,:,i,1),[],3))./max(mean(mean(PDF(:,:,:,i,1),3))),'r'),
    plot(xx,100*mean(std(PDF(:,:,:,i,2),[],3))./max(mean(mean(PDF(:,:,:,i,2),3))),'g'),
end



clf;
for i=1:4, hold on,
    plot(xx,100*(mean(mean(PDF(:,:,:,i,1),3))),'b'),
    plot(xx,100*(mean(mean(PDF(:,:,:,i,2),3))),'k'),
end

X=Tpoly.vert(:,1);Y=Tpoly.vert(:,2);Z=Tpoly.vert(:,3);
for i=1:4
    for j=1:2
        figure(100)
        mx = mean(repmat(abs(xx),[258 1]).*mean(PDF(:,:,:,i,j),3),2);
        sx= mean(std(PDF(:,:,:,i,j),[],3),2);
        [TH,PHI,R] = cart2sph(X,Y,Z);
        [x,y,z]=sph2cart(TH,PHI,mx/max(mx));
        TT = Tpoly;
        TT.vert =[x+i y+j z];
        sx = sx-min(sx);
        TT.vertclr = [sx sx 0*sx ]/max(sx);
        patchpoly(TT,'edgecolor','none')
    end
end


X=Tpoly.vert(:,1);Y=Tpoly.vert(:,2);Z=Tpoly.vert(:,3);
for i=1
    for j=1
        figure(100)
        mx = mean(repmat(abs(xx),[258 1]).*mean(PDF(:,:,:,i,j),3),2);
        sx= mean(std(PDF(:,:,:,i,j),[],3),2);
        [TH,PHI,R] = cart2sph(X,Y,Z);
        [x,y,z]=sph2cart(TH,PHI,mx);
        TT = Tpoly;
        TT.vert =[x+i y+j z];
        %         sx = sx-min(sx);
        %         TT.vertclr = [sx sx 0*sx ]/max(sx);
        patchpoly(TT,'edgecolor','none','facealpha',.1)
        view(30,30);
        pause
        [x,y,z]=sph2cart(TH,PHI,mx+6*sx);
        TT = Tpoly;
        TT.vert =[x+i y+j z];
        %         sx = sx-min(sx);
        %         TT.vertclr = [sx sx 0*sx ]/max(sx);%
        patchpoly(TT,'edgecolor','none','facealpha',.1)
        pause
        [x,y,z]=sph2cart(TH,PHI,mx-6*sx);
        TT = Tpoly;
        TT.vert =[x+i y+j z];
        %         sx = sx-min(sx);
        %         TT.vertclr = [sx sx 0*sx ]/max(sx);%
        patchpoly(TT,'edgecolor','none','facealpha',.1)
    end
end

close all
X=Tpoly.vert(:,1);Y=Tpoly.vert(:,2);Z=Tpoly.vert(:,3);
map = hsv(100);
for i=3
    for j=2
        figure(i*10+j)
          set(gcf,'renderer','OpenGL')
        for k=1:25
            disp([i j  k])
            for Q=[.1 .5 .9]
            %         mx = mean(repmat(abs(xx),[258 1]).*mean(PDF(:,:,k,i,j),3),2);
            for l=1:size(PDF,1)
                mx(l) = percentile(xx,PDF(l,:,k,i,j),Q);
            end
            sx= mean(std(PDF(:,:,:,i,j),[],3),2);
            [TH,PHI,R] = cart2sph(X,Y,Z);
            [x,y,z]=sph2cart(TH,PHI,mx);
            TT = Tpoly;
            TT.vert =[x+i y+j z];
            %         sx = sx-min(sx);
            %         TT.vertclr = [sx sx 0*sx ]/max(sx);
            if(j==1)
            TT.vertclr =map(min(100,round(mx*100/6)+1),:);
            else
            TT.vertclr =map(min(100,round(mx*100/15)+1),:);
            end
           h= patchpoly(TT,'edgecolor','interp','facecolor','none','EdgeAlpha',.05);
           
            %             patchpoly(TT,'edgecolor','none','facealpha',.005)
%             view(30,30);
            end
%             pause
 
        end
     disp('wait')
            pause(1)
            disp('next')
        axis equal off tight
        if(j==1)
            axis([-1 1 -1 1 -1 1]*7)
        else 
            axis([-1 1 -1 1 -1 1]*20)
        end
        view(0,0);axis equal off, set(gcf,'color','w')
        pause(30)
        drawnow
         eval(['print -dpng -r300 ' num2str(i) '-' num2str(j)])
         pause(10)
         close
    end
end

sPDF = std(PDF,[],3);
mPDF = mean(PDF,3);
probR = (squeeze(mean(repmat(max(mPDF,[],1),[258 1 1 1 1]),1)));
PSNRr = -20*log10(squeeze(mean(sPDF./repmat(max(mPDF,[],1),[258 1 1 1 1]),1)));
probT = (squeeze(mean(repmat(max(mPDF,[],2),[1 250  1 1 1]),2)));
PSNRt = -20*log10(squeeze(mean(sPDF./repmat(max(mPDF,[],2),[1 250  1 1 1]),2)));

figure(1);
subplot(2,1,1);plot(xx,PSNRr(:,:,1)) 
ylabel('PSNR_r (dB)'); xlabel('Displacement (mm)')
title('2 ms')
subplot(2,1,2);plot(xx,PSNRr(:,:,2))
title('20 ms')
ylabel('PSNR_r (dB)'); xlabel('Displacement (mm)')
legend('1','2','3','4')

figure(2);
subplot(2,1,1);plot(PSNRt(:,:,1)) 
ylabel('PSNR_r (dB)'); xlabel('Orientation Index (a.u.)')
a=axis;
a(2)=258/2;axis(a)
title('2 ms')
subplot(2,1,2);plot(PSNRt(:,:,2))
title('20 ms')
ylabel('PSNR_r (dB)'); xlabel('Orientation Index (a.u.)')
a=axis;
a(2)=258/2;axis(a)