% Figure 1.A
% cylinder w/ finite gradients
clear java;
clear all;
spacing = 1;
latticeDimensions = [11 11 11];
SpinLocations = 'RandomInside';
DT = 100; % ms
figure(99);
clf;
NJ=50;
CR = [2.5]; %um
[X,Y]=ndgrid(linspace(-100,100,100),linspace(-100,100,100));
C = (X.^2+Y.^2)<100^2;
a=conv2(C+0,C+0);
yc=(a(100,:));
NSTEPS = [1000];%1 2 5 10 20 50 100];% 20 50 100 200 500 1000];
bvalue = 1e3; %mm2/s
load jones30.grad
for jCR = 1%:length(CR)
    cyl_rad = CR(jCR);
    xc = linspace(-2*cyl_rad ,2*cyl_rad,length(yc));
    yc=yc./trapz(xc,yc)
    Fc = cumtrapz(xc,yc);
    for jDT = 1
        MaxDiffusionTimeMS = DT(jDT); % maximum diffusion time in ms
        numSpinPackets = 10000;
        %         timesteps=MaxDiffusionTimeMS./round(logspace(1,3,11));
        
        for ti=1:length(NSTEPS)
            timestep=round(MaxDiffusionTimeMS/NSTEPS(ti))%timesteps(ti);
            steps(ti) = NSTEPS(ti);%round(MaxDiffusionTimeMS/timestep);
            
            spins(ti) = numSpinPackets;
            tic;
            for j=1:NJ
                [diffusionModel,diffusionTimeMS,MotionResults,...
                    displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D] ...
                    ...%                     nmr09freediffusion(spins(ti),MaxDiffusionTimeMS*1000/steps(ti),latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
                    = nmr09cylinderFG(cyl_rad,spins(ti),MaxDiffusionTimeMS*1000/steps(ti),latticeDimensions,SpinLocations,MaxDiffusionTimeMS,...
                    bvalue,jones30);
                [adc,signal] = simulateADCwithB(MotionResults,jones30,1000);
                infGrad(:,j) = abs(mean(signal')');
                finGrad(:,j) = abs(mean(exp(sqrt(-1)*MotionResults.fgPhaseReults))');
                figure(99);
                plot(finGrad,infGrad,'x');axis([0 1 0 1]); xlabel('finite/bipolar'); ylabel('SGP')
                drawnow; hold on
                figure(100)
                plot(finGrad,finGrad./infGrad,'x')
                drawnow;
            end
            
        end
    end
end
figure(101);
errorbar(mean(finGrad,2),mean(finGrad./infGrad,2),std(finGrad./infGrad,[],2),'kx')
set(gca,'YGrid','on')
axis([0 1.05 .95 1.05])
xlabel('Mean Signal with Finite Gradient Model')
ylabel('Ratio of Signal with Finite Gradients to SGP Model')
title('Impact of Gradient Simulation Model')