function [b_value,diffusionModel,diffusionTimeMS,MotionResults,displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= nmr09cylinder(cyl_rad,numSpinPackets,timestep,latticeDimensions,SpinLocations,MaxDiffusionTimeMS,perm)

% clc;
%close all;
%clear all
try
RWSsetup()
catch
RWSsetup()
end

extraCompartmentDiffusivity=2e-3;
intraCompartmentDiffusivity=2e-3;
membranePermeability=perm;
%LD = 3;
%latticeDimensions = [LD LD LD];
cylinderLength = 3*latticeDimensions(3);
%cyl_rad = 1.4;
%sph_rad = 0;
%numSpinPackets = 100; %number of packets
NSteps = 1; % number of diffusion time steps

timeStepUS = timestep; %us 20us timestep,D = 2e-3,root(6DtimeStep) = 0.5um, step.  

% parameters for diffusion weighting experiment
T2 = 100;
encodingDir = [1 0 0; 0 1 0; 0 0 1];
delta = 3; %ms
G = [0:10:1200]; %mT/m (1200mT/m = 120G/cm)
gamma = 267.52e6; % rad s-1 T-1
gamma = gamma/(1000*1000); % rad ms-1 mT-1
center=latticeDimensions/2;
diffusionModel.Geometry{1} = RWScreateCompartmentCylinder(T2,intraCompartmentDiffusivity,membranePermeability,center,cyl_rad,cylinderLength);;
% unit_center_cyl_spheres(T2,latticeDimensions,cylinderLength,cyl_rad,sph_rad,intraCompartmentDiffusivity,transmissionProbability,flag);



diffusionTimeMS = linspace(0,MaxDiffusionTimeMS,NSteps+1); %ms
diffusionTimeMS = diffusionTimeMS(2:end);

% compute the b-values
for ii = 1:length(diffusionTimeMS)
    for jj = 1:length(G)
        b_value(ii,jj) = 1e-9*(gamma*delta*G(jj))^2*(diffusionTimeMS(ii));
    end
end

% Convert times arguments to stanard units:
diffusionTimeUS = diffusionTimeMS(end)*1000/NSteps; % ms -> us

% 1) Initialize Java Simulator
javaSimulator = RWSnewSimulator(extraCompartmentDiffusivity,latticeDimensions,T2);
javaSimulator.intenseDebug=0;

% 3) Enter the geometries
currentGeometry=[];
for j=1:length(diffusionModel.Geometry)
    [compartmentIndex(j),currentGeometry]=RWSaddCompartment(javaSimulator,diffusionModel.Geometry{j},currentGeometry);
end

% 4) select number of spins
%SpinLocations = 'RandomInside';
RWSaddSpins(javaSimulator,numSpinPackets,SpinLocations);

%MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);

SignalAtten = zeros([size(encodingDir,1) length(G) length(diffusionTimeMS)]);
for ii = 1:length(diffusionTimeMS)

    % 5) simulate the random walks (non-interacting)

    % 6) read out results

    MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);
    
    tic
    displacement = sqrt(sum(MotionResults.brownianMotion.^2,2));
    displacementx(:,ii) =  MotionResults.brownianMotion(:,1);
    displacementy(:,ii) =  MotionResults.brownianMotion(:,2);
    displacementz(:,ii) =  MotionResults.brownianMotion(:,3);
    rmsd(ii) = sqrt(mean(displacement.^2)); %um
    rmsd_vec(:,ii) = sqrt([mean(displacementx(:,ii).^2) mean(displacementy(:,ii).^2) mean(displacementz(:,ii).^2)]);
    
%     signal = zeros([size(encodingDir,1) numSpinPackets length(G)]);
%     for jj = 1:length(G)
%         GradLobeArea = delta*G(jj)/100; %(mT/cm)*ms
%         % adc and the phase dispersions for all spin packets
%         [adc,signal(:,:,jj)] = simulateADC(MotionResults,encodingDir,GradLobeArea);
%     end
%     % Calculate the signal attenuation
%     SignalAtten(:,:,ii) = squeeze(abs(mean(signal(:,:,:),2)));
%     toc
        
end
adj_rmsd = rmsd/1000; %mm

if strcmpi(SpinLocations,'RandomOutside')
    D = extraCompartmentDiffusivity; %mm^2/s
elseif strcmpi(SpinLocations,'RandomInside')
    D = intraCompartmentDiffusivity; % mm^2/s 
elseif strcmpi(SpinLocations,'Random')
    D = extraCompartmentDiffusivity; % mm^2/s
end

D = D/1000; % mm^2/ms
