function showADCImages(motionResults, handles)
% showADCImages -- show emperical diffusion plot (internal use)
%   showADCImages(motionResults, handles)
%       motionResults - results from simulator
%       handles - MRMproject GUI handles (used to exchange data)
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

% Step 1. Generate the plot in the main window.
cla;
adc = get(handles.ADC,'UserData');
h = plot(adc,'.','MarkerSize',40)
set(gca,'xtick',1:length(adc));
a = axis;
a(1) = 0; a(2) = length(adc)+1; a(3) = 0;
axis(a);
xlabel('Diffusion Encoding Direction')
ylabel('Apparent Diffusion');
title('Simulated ADC By Encoding (Weighting) Direction')