function showTensorFit(handles)
% showTensorFit -- show a 3D visualization of a tensor (internal use)
%   showTensorFit(handles)
%       handles - MRMproject GUI handles (used to exchange data)
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

% Step 1. Retrieve data 
adc = get(handles.ADC,'UserData');
grad = get(handles.diffusionWeightingFile,'userdata');
[th,ph,r] = cart2sph(grad(:,1),grad(:,2),grad(:,3));
[x,y,z] = sph2cart(th,ph,ones(size(th)));
grad = [x y z];

% Step 2. Estimate tensor and identify eigenvalues
[Tensor,D] = estimateTensor(grad,adc);
[v,e] = eigs(Tensor);
es = sort([e(1,1) e(2,2) e(3,3)]);

% Step 3. Use tensor to estimate ADC a many points on a sphere
[X,Y,Z] = sphere(41);
A2 = ([X(:)'.^2; X(:)'.*Y(:)'*2; X(:)'.*Z(:)'*2; Y(:)'.^2; Y(:)'.*Z(:)'*2; Z(:)'.^2]');
[th,ph,r]=cart2sph(X(:),Y(:),Z(:));
[x2,y2,z2] = sph2cart(th,ph,A2*D);
x2=reshape(x2,size(X));
y2=reshape(y2,size(X));
z2=reshape(z2,size(X));

% Step 4. Visualize ADC by warping sphere
h=mesh(x2,y2,z2);
set(h,'facecolor','yellow','facealpha',.75,'edgecolor','none');
hold on
axis equal;
a = axis;
% Step 5. Show the eigenvectors
for je=1:3
    [i,j] = find(e==es(je));
    hold on;
    disp([v(1,j)*es(je),v(2,j)*es(je),v(3,j)*es(je)])
    %h=quiver3(0,0,0,v(1,j)*es(je),v(2,j)*es(je),v(3,j)*es(je));
    h=plot3([0 v(1,j)*es(je)],[0 v(2,j)*es(je)],[0 v(3,j)*es(je)]);
    for k=1:length(h)
    set(h(k),'linewidth',4)
    end
    hold on;
end
axis off;
set(gcf,'color','white');
light;
lighting phong
axis(a);

% Step 6. Show an animation
busy
for i=0:180
    view(i,30);
    pause(.01);
end
idle