function showWalkProb(motionResults, handles, figHandle)
% showWalkProb -- show 3D slices through emperical motion distribution (internal use)
%   showWalkProb(motionResults, handles, figHandle)
%       motionResults - results from motion simulator
%       handles - MRMproject GUI handles (used to exchange data)
%       figHandle - handle to figure to show 3d results
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

% Step 1. Create a 3D histogram
motion=motionResults.brownianMotion;
a = axis;
N = 31;
N2 = round(N/2);
R = max(abs(motion(:)));
n = repmat(linspace(-R,R,N),[3 1])';
cnt = zeros([N N N]);
for j=1:size(motion,1)
    c = sum(repmat(motion(j,:),[N 1])>=n);
    cnt(c(1),c(2),c(3))=cnt(c(1),c(2),c(3))+1;
end

% Step 2. Setup the triplanar projections
j=1;
cla
[x,y,z]=meshgrid(1:N,1:N,j);
h(1)=patch(surf2patch(x,y,z,cnt(1:N,1:N,j)));
set(h(1),'facealpha',.75)
set(h(1),'edgecolor','none')
[x,y,z]=meshgrid(1:N,N2,1:N);
h(2)=patch(surf2patch(squeeze(x),squeeze(y),squeeze(z),squeeze(cnt(1:N,N2,1:N))));
set(h(2),'facealpha',.25)

set(h(2),'edgecolor','none')
[x,y,z]=meshgrid(N2,1:N,1:N);
h(3)=patch(surf2patch(squeeze(x),squeeze(y),squeeze(z),squeeze(cnt(N2,1:N,1:N))));
set(h(3),'facealpha',.25)
set(h(3),'edgecolor','none')

% Step 3. Tweak 3D visual effects
shading faceted
for j=1:3
    set(h(j),'edgecolor','none');
end
axis off
axis  tight equal
view(54,30)
set(gcf,'color','white')

% Step 4. Animate the axial slice as it rises through the volume
for j=[1:N]
    [x,y,z]=meshgrid(1:N,1:N,j);
    dat=surf2patch(x,y,z,cnt(1:N,1:N,j));
    set(h(1),'facevertexcdata',dat.facevertexcdata)
    set(h(1),'Vertices',dat.vertices)

    pause(0.05)
end
f = linspace(55,(90+54),N);
k=1;

% Step 5. Animate the axial slice as it falls through the volume while
% rotating the field of view
for j=N:-1:1

    [x,y,z]=meshgrid(1:N,1:N,j);
    dat=surf2patch(x,y,z,cnt(1:N,1:N,j));
    set(h(1),'facevertexcdata',dat.facevertexcdata)
    set(h(1),'Vertices',dat.vertices)
    view(f(k),30);
    k=k+1;
    pause(0.05)
end