function [S_sim_ave,S_sim_smallq_ave] = simAxonsQspace()

warning off all
gamma = 2.67522200e8; % radians/(s*T)
delta = 5e-3;
BIG_delta = 100e-3;
G = [0:1:5000];% G/cm 1 G/cm = 10mT/m
%G = linspace(3,100,30);
G = 10e-3*G; %T/m

q = (gamma/(2*pi()))*delta*G; %1/m
b = ((gamma*gamma*delta*delta)*G.^2)*(BIG_delta-0); %s/m^2


% Radius between barriers in microns
%R(:,1) = 2*ones([1000,1]);
R(:,1) = 1; % normrnd(2,0.3,1000,1) + 0;
%R(:,2) = 2; 
%R(:,3) = 5; 

%R(:,3) = 3;

%R(:,1) = gamrnd(3,1/3,1000,1)+0.2;
%R(:,1) = [[raylrnd(0.5,900,1) + 0.2]; [raylrnd(0.5,100,1) + 1.2]];
%R(:,1) = 2% raylrnd(0.5,1000,1) + 0.2;
%R(:,3) = raylrnd(0.5,1000,1) + 2.2;
%R(:,2) = raylrnd(0.5,1000,1) + 1.2;
%R(:,3) = raylrnd(0.5,1000,1) + 2.2;
%R(:,2) = 2;%raylrnd(1.5,1000,1) + 0.5;
%R(:,3) = raylrnd(2.5,1000,1) + 0.5;

%R(:,1) = normrnd(1,0.3,100,1) + 0.0;
%R(:,1) = raylrnd(1,1000,1) + 1;
%R(:,2) = raylrnd(1,1000,1) + 1.5;
%R(:,2) = R(:,1) + 2; %normrnd(3,0.3,1000,1) + 0;
%R(:,3) = R(:,1) + 4;
%R(:,3) = normrnd(5,0.3,1000,1) + 0;
%R(:,3) = normrnd(2,0.5,1000,1) + 0;
%R(:,3) = raylrnd(1,1000,1) + 1;



%vec = [vec; raylrnd(2,1000,1)];
color = 'rcb';
shape = 'ooo'
histbins = [0:0.1:10]*1e-6;
R = R*1e-6;

%1/(2*pi*a)

S_sim = zeros([length(q),size(R,1)]);
S_sim_smallq = S_sim;
S_sim_ave = zeros([length(q),size(R,2)]);
S_sim_smallq_ave = S_sim_ave;

for jj = 1:size(R,2)
    tic
    for ii=1:size(R,1)
        
        % =======================================
%         % plates of diameter 2R
%         a = 2*R;
%         S_sim(:,ii) = abs(sinc(q*a(ii,jj))).^2; % don't put pi in sinc
%         %%function in matlab
%         S_sim(:,ii) = 2*(1-cos(2*pi*q*a(ii,jj)))./((2*pi*q*a(ii,jj)).^2);
%         %%long BIG_delta, small q
%         Dapp = ((a(ii,jj))^2)/(12*BIG_delta);
%         S_sim_smallq(:,ii) = exp(-b*Dapp);
        % ========================================

        % =======================================
        % soderman O, Johnsson N, restricted diffusion in cylindrical
        % geometry, equation 6
        
        % Price WS, Pulsed field gradient nucler magnetic
        % resonance as a tool for studying translational diffusion
        % part 1. Basic theory, equation 114
        
        % 
        %%cylinder, perpendicular, long BIG_delta
        Z  = 2*pi*q*R(ii,jj);
        J = besselj(1,Z);
        S_sim(:,ii) = ((2*J).^2)./((2*pi*q*R(ii,jj)).^2);
        %%long BIG_delta, small q
        Dapp = ((R(ii,jj))^2)/(4*BIG_delta);
        S_sim_smallq(:,ii) = exp(-b*Dapp);
        % ============================================

        % =======================================
        % soderman O, Johnsson N, restricted diffusion in cylindrical
        % geometry, equation 5
        
        % Price WS, Pulsed field gradient nucler magnetic
        % resonance as a tool for studying translational diffusion
        % part 1. Basic theory, equation 113
        
        % cylinder, function of theta, long BIG_delta
%         theta = 45.001;
%         theta = theta*pi/180;
%         
%         L = 2*R(ii,jj);
%         Z  = 2*pi*q*R(ii,jj)*sin(theta);
%         J = besselj(1,Z);
%         
%         top1 = (R(ii,jj))^2;
%         top2 = 1 - cos(2*pi*q*L*cos(theta));
%         top3 = J.^2;
%         bot1 = (2*pi*q*R(ii,jj)).^4;
%         bot2 = (L*cos(theta)*sin(theta))^2;
%         
%         S_sim(:,ii) = 8*top1.*top2.*top3./(bot1.*bot2);
%         
%         Dapp = ((R(ii,jj))^2)/(4*BIG_delta);
%         S_sim_smallq(:,ii) = exp(-b*Dapp);
        % ============================================
        
    end
    toc
    S_sim_ave(:,jj) = mean(S_sim,2);
    S_sim_smallq_ave(:,jj) = mean(S_sim_smallq,2);
    
    Nvec = histc(R(:,jj),histbins);
    plotme(b,q,R(:,jj),S_sim_ave(:,jj),color(jj),shape(jj),Nvec,histbins,S_sim_smallq_ave(:,jj)) 
       
end

mean(Dapp(:))

for jj = 1:size(R,2);
    S_sim_ave(1,jj) = 0.5;
    S_sim_smallq_ave(1,jj) = 0.5;
    % take a Fourier Transform of the data
    Y = fft(S_sim_ave(:,jj));
    abs_Y = real(Y)';
    Y2 = fft(S_sim_smallq_ave(:,jj));
    abs_Y2 = real(Y2)';

    kabs_Y(jj,:) = abs_Y;
    kabs_Y2(jj,:) = abs_Y2;
    
    ff = 1e6*q/(max(q)*(q(2)-q(1)));

    figure(26)
    Const = 1;
    title('PDF'), hold on
    plot([-fliplr(ff) ff],[fliplr(abs_Y) abs_Y]./Const,'bo-'), hold on
    plot([-fliplr(ff) ff],[fliplr(abs_Y2) abs_Y2]./Const,['ko-']), hold on
    %axis([-2e6*max(R) 2e6*max(R) -0.1 max(abs_Y(:))]);
    xlabel('distance in microns','fontsize',12)
    ylabel('probability','fontsize',12)
end


mkabs_Y = mean(kabs_Y,1);
mkabs_Y2 = mean(kabs_Y2,1);
size(mkabs_Y)

figure(26)
Const = 1;
title('PDF'), hold on
plot([-fliplr(ff) ff],[fliplr(mkabs_Y) mkabs_Y]./Const,'go-'), hold on
plot([-fliplr(ff) ff],[fliplr(mkabs_Y2) mkabs_Y2]./Const,['mo-']), hold on
%axis([-2e6*max(R) 2e6*max(R) -0.1 max(mean(kabs_Y2(:)))]);
xlabel('distance in microns','fontsize',12)
ylabel('probability','fontsize',12)



function plotme(b,q,R,S_sim_ave,color,shape, Nvec,histbins,S_sim_smallq_ave)
% supperimpose on top of 
%Total_Signal = 0.7*S_sim_ave + 0.3*exp(-b*0.1e-3*1e-6)';
%S_sim_smallq_ave = 0.7*S_sim_smallq_ave + 0.3*exp(-b*0.1e-3*1e-6)';
Total_Signal = S_sim_ave;
S_sim_smallq_ave = S_sim_smallq_ave;

%Total_Signal = exp(-b*1e-3*1e-6)';

a = 12;
aa = 10;

figure(1)
plot(b/1e6,Total_Signal,[color shape],'markerfacecolor',color,'markersize',aa), hold on
plot(b/1e6,S_sim_smallq_ave,'k-'), hold on
xlabel('b value in s/mm^2','fontsize',a)
ylabel('Signal','fontsize',a)
set(gca,'fontsize',a)

figure(2)
plot(b/1e6,log(Total_Signal),[color shape],'markerfacecolor',color,'markersize',aa),hold on
plot(b/1e6,log(S_sim_smallq_ave),'k-'), hold on
xlabel('b value in s/mm^2','fontsize',a)
ylabel('Log of Signal','fontsize',a)
set(gca,'fontsize',a)

figure(3)
plot(q,Total_Signal,[color shape],'markerfacecolor',color,'markersize',aa),hold on
plot(q,S_sim_smallq_ave,'k-'), hold on
xlabel('q value in inverse meters','fontsize',a)
ylabel('Signal','fontsize',a)
set(gca,'fontsize',a)

figure(4)
plot(q,log(Total_Signal),[color shape],'markerfacecolor',color,'markersize',aa),hold on
plot(q,log(S_sim_smallq_ave),'k-'), hold on
xlabel('q value in inverse meters','fontsize',a)
ylabel('Log of Signal','fontsize',a)
set(gca,'fontsize',a)

figure(5)
plot(q*1e-6,log(Total_Signal),[color shape],'markerfacecolor',color,'markersize',aa),hold on
plot(q*1e-6,log(S_sim_smallq_ave),'k-'), hold on
xlabel('q in 1/microns','fontsize',a)
ylabel('Log of Signal','fontsize',a)
set(gca,'fontsize',a)

figure(11)
plot(b/1e6,Total_Signal,[color shape],'markerfacecolor',color,'markersize',aa), hold on
plot(b/1e6,S_sim_smallq_ave,'k-'), hold on
xlabel('b value in s/mm^2','fontsize',a)
ylabel('Signal','fontsize',a)
axis([0 10000 0 1])
set(gca,'fontsize',a)

figure(12)
plot(b/1e6,log(Total_Signal),[color shape],'markerfacecolor',color,'markersize',aa),hold on
plot(b/1e6,log(S_sim_smallq_ave),'k-'), hold on
xlabel('b value in s/mm^2','fontsize',a)
ylabel('Log of Signal','fontsize',a)
axis([0 10000 -0.5 0])
set(gca,'fontsize',a)

figure(13)
plot(histbins*1e6,Nvec,[color '-' shape],'markerfacecolor',color,'markersize',aa), hold on
xlabel('Radius of cylinders, in microns','fontsize',a)
set(gca,'fontsize',a)
axis([0 3.5 0 200])

Total_Signal(1) = 0.5;
S_sim_smallq_ave(1) = 0.5;
% take a Fourier Transform of the data
Y = fft(Total_Signal);
abs_Y = real(Y)';
Y2 = fft(S_sim_smallq_ave);
abs_Y2 = real(Y2)';

ff = 1e6*q/(max(q)*(q(2)-q(1)));

abs_Y = abs_Y(1:round(end/2));
abs_Y2 = abs_Y2(1:round(end/2));
ff = ff(1:round(end/2));

[x,xvec,V2Dproj,C2Dproj,C] = simAxonsQspace_convolutions(R*1e6,'circle');

figure(16)
title('PDF'), hold on
PDF_Y = [fliplr(abs_Y) abs_Y];
PDF_Y2 = [fliplr(abs_Y2) abs_Y2];
xx = [-fliplr(ff) ff];
Const = trapz(xx,PDF_Y);
PDF_Y = PDF_Y/Const;
Const = trapz(xx,PDF_Y2);
PDF_Y2 = PDF_Y2/Const;

plot(xx,PDF_Y,[color '-' shape]), hold on
plot(xx,PDF_Y2,['ko-']), hold on
plot(x,V2Dproj,'m*-'); hold on
plot(xvec,C2Dproj,'g*-'); hold on

axis([-2e6*max(R) 2e6*max(R) -0.1 1.1*max(PDF_Y2(:))]);
xlabel('distance in microns','fontsize',12)
ylabel('probability','fontsize',12)
legend('full solution ', 'small q approximation ')

%figure(17)
%Const = 1;
%title('Ln of PDF'), hold on
%plot([-fliplr(ff) ff],log([fliplr(abs_Y) abs_Y]./Const),[color '-' shape]), hold on
%plot([-fliplr(ff) ff],log([fliplr(abs_Y2) abs_Y2]./Const),['ko-']), hold on
%axis([-2e6*max(R) 2e6*max(R) -0.1 5]);
%xlabel('distance in microns','fontsize',12)
%ylabel('probability','fontsize',12)

