function [adc,signal] = simulateADC(motionInfo,encodingDir,GradLobeArea)
% simulateADC -- compute adc given emperical motion information
%   [adc,signal] = simulateADC(motionInfo,encodingDir,GradLobeArea)
%       motionInfo - results of the motion simulator
%       encodingDir - Nx3 matrix with gradient encoding directions
%       (normalized, unit length)
%       GradientLobeArea - area of one gradient lobe (mT/cm*ms)
%       adc - Nx1 vector of observed adc
%       signal - NxM matrix of complex signals from each of the simulated
%       spin packets
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

% Step 1. Loop over all encoding gradients
gamma = 267.52e6; % rad s-1 T-1
gamma = gamma/(1000*1000); % rad ms-1 mT-1
%q = gamma*GradLobeArea/10; % 1/mm % GradLobeArea => mT/cm * ms
q = (gamma/(2*pi))*GradLobeArea/10; % 1/mm % GradLobeArea => mT/cm * ms
disp(q);
b = 4*pi*pi*q^2*(motionInfo.parameters.diffusionTime/1e6)
adc = [];
signal=zeros([size(encodingDir,1) size(motionInfo.brownianMotion,1)]);
for jDir = 1:size(encodingDir,1)
    
    % Step 2. Loop over all spin packets
    for jPt = 1:size(motionInfo.brownianMotion,1)
        % Step 2a. compute motion along chosen gradient direction
        motion(jPt) = dot(motionInfo.brownianMotion(jPt,:),encodingDir(jDir,:));
    end    
    % Step 3. Compute phase dispersion due to motion
    %signal(jDir,:) = exp(i.*q.*motion/1e3); % motion in um, q in 1/mm
    signal(jDir,:) = exp(i.*2*pi*q.*motion/1e3); % motion in um, q in 1/mm
    % Step 4. Simulate attenuation due to motion/phase dispersion
    %adc(jDir) = -1/(q^2*(motionInfo.parameters.diffusionTime/1e6))*log(abs(mean(signal(jDir,:)))); % mm2/s
    adc(jDir) = -1/(4*pi*pi*q^2*(motionInfo.parameters.diffusionTime/1e6))*log(abs(mean(signal(jDir,:)))); % mm2/s => diffusion time is in us
end