function [F, E] = electricForceHeir(x,y,z,levels,levelwt)
% function [F, E] = electricForceHeir(x,y,z,levels,levelwt)
% 
% NOTE: The point arguments to this function are (x,y,z). This fcn 
% assumes that both (x,y,z) and (-x,-y,-z) are in the point set being 
% optimized. (Forced symmetric placement).
% 
% Compute the net pseudo force (F) on each point (x,y,z) by assuming 
% that each point represents a unit charge and that forces
% are governed by Coulomb's law and is repelled by each other point
% with a strength of 1/r^2, where r is the distance between them. Forces
% are assumed to be vector-additive. 
%
% The potential of the system is estimated by the sum of 1/r for all pairs 
% of oints. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

pts = length(x); 
Fs = zeros([pts*2 3 pts]);
for j=1:pts
    v = [[x -x]' [y -y]' [z -z]']-repmat([x(j) y(j) z(j)],[2*pts 1]);
    v(j,:)=inf;
    invR(j,:) = 1./sqrt(sum(v'.*v'));
    Fs(:,:,j) = -1*(v./repmat(((sum(v'.*v'))').^(3/2),[1 3]));    
end
Fs(find(isnan(Fs(:))))=0;
F= zeros([pts 3]);
for j=1:levels
    inc = 1:(pts/2^(levels-j));
    off = min(inc)-1;
    while(off<pts)
%         for jpt=(inc+off)
%         %f = staticForces([x(inc+off) -x(inc+off)],[y(inc+off) -y(inc+off)],[z(inc+off) -z(inc+off)]);
%         F(jpt,:) = F(jpt,:)+sum(Fs([inc+off inc+off+pts],:,jpt))*levelwt.^(j-1);
%         end
          F(inc+off,:) = F(inc+off,:)+(permute(sum(Fs([inc+off inc+off+pts],:,inc+off),1),[3 2 1]))*levelwt.^(j-1);
        off = off+max(inc);
    end
end
E = sum(invR(:))/2;